/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opentripplanner.framework.token.Deserializer;
import org.opentripplanner.framework.token.Token;
import org.opentripplanner.framework.token.TokenBuilder;
import org.opentripplanner.framework.token.TokenDefinition;
import org.opentripplanner.framework.token.TokenDefinitionBuilder;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class TokenSchema {
    private final List<TokenDefinition> definitions;

    TokenSchema(List<TokenDefinition> definitions) {
        ArrayList<TokenDefinition> list = new ArrayList<TokenDefinition>(definitions);
        Collections.reverse(list);
        this.definitions = List.copyOf(list);
    }

    public static TokenDefinitionBuilder ofVersion(int baseVersion) {
        return new TokenDefinitionBuilder(baseVersion);
    }

    public Token decode(String token) {
        Deserializer deserializer = new Deserializer(token);
        for (TokenDefinition definition : this.definitions) {
            try {
                return new Token(definition, deserializer.deserialize(definition));
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("Token is not valid. Unable to parse token: '" + token + "'.");
    }

    public TokenBuilder encode() {
        return new TokenBuilder(this.currentDefinition());
    }

    public TokenDefinition currentDefinition() {
        return this.definitions.get(0);
    }

    public String toString() {
        return ToStringBuilder.of(TokenSchema.class).addObj("definition", (Object)this.currentDefinition()).toString();
    }
}

