/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.framework.token.FieldDefinition;
import org.opentripplanner.framework.token.TokenDefinition;
import org.opentripplanner.framework.token.TokenSchema;
import org.opentripplanner.framework.token.TokenType;
import org.opentripplanner.utils.collection.ListUtils;
import org.opentripplanner.utils.lang.IntUtils;

public class TokenDefinitionBuilder {
    private final int version;
    private final List<TokenDefinition> tokensHead = new ArrayList<TokenDefinition>();
    private final List<FieldDefinition> fields = new ArrayList<FieldDefinition>();

    TokenDefinitionBuilder(int version) {
        this.version = IntUtils.requireInRange((int)version, (int)1, (int)1000000);
    }

    TokenDefinitionBuilder(List<TokenDefinition> head, TokenDefinition last) {
        this(last.version() + 1);
        this.fields.addAll(last.listNonDeprecatedFields());
        this.tokensHead.addAll(head);
        this.tokensHead.add(last);
    }

    public TokenDefinitionBuilder addByte(String fieldName) {
        return this.add(fieldName, TokenType.BYTE);
    }

    public TokenDefinitionBuilder addBoolean(String fieldName) {
        return this.add(fieldName, TokenType.BOOLEAN);
    }

    public TokenDefinitionBuilder addDuration(String fieldName) {
        return this.add(fieldName, TokenType.DURATION);
    }

    public TokenDefinitionBuilder addEnum(String fieldName) {
        return this.add(fieldName, TokenType.ENUM);
    }

    public TokenDefinitionBuilder addInt(String fieldName) {
        return this.add(fieldName, TokenType.INT);
    }

    public TokenDefinitionBuilder addString(String fieldName) {
        return this.add(fieldName, TokenType.STRING);
    }

    public TokenDefinitionBuilder addTimeInstant(String fieldName) {
        return this.add(fieldName, TokenType.TIME_INSTANT);
    }

    public TokenDefinitionBuilder deprecate(String fieldName) {
        int index = this.indexOfField(fieldName);
        if (index < 0) {
            throw new IllegalArgumentException("The field '" + fieldName + "' does not exist! Deprecation failed.");
        }
        this.fields.set(index, this.fields.get(index).deprecate());
        return this;
    }

    private int indexOfField(String fieldName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).name().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public TokenDefinitionBuilder newVersion() {
        return new TokenDefinitionBuilder(this.tokensHead, this.buildIt());
    }

    public TokenSchema build() {
        return new TokenSchema(ListUtils.combine((Collection[])new Collection[]{this.tokensHead, List.of(this.buildIt())}));
    }

    private TokenDefinition buildIt() {
        return new TokenDefinition(this.version, this.fields);
    }

    private TokenDefinitionBuilder add(String fieldName, TokenType type) {
        this.fields.add(new FieldDefinition(fieldName, type));
        return this;
    }
}

