/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.framework.token.FieldDefinition;
import org.opentripplanner.framework.token.TokenType;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class TokenDefinition {
    private final int version;
    private final List<String> fieldNames;
    private final Map<String, FieldDefinition> fields;

    TokenDefinition(int version, List<FieldDefinition> fields) {
        this.version = version;
        this.fieldNames = fields.stream().map(FieldDefinition::name).toList();
        this.fields = TokenDefinition.immutableMapOf(fields);
    }

    public int version() {
        return this.version;
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public TokenType type(String fieldName) {
        return this.fields.get(fieldName).type();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenDefinition that = (TokenDefinition)o;
        return this.version == that.version && this.listFields().equals(that.listFields());
    }

    public int hashCode() {
        return Objects.hash(this.version, this.listFields());
    }

    public String toString() {
        return ToStringBuilder.of(TokenDefinition.class).addNum("version", (Number)this.version, (Number)0).addCol("fields", this.listFields()).toString();
    }

    int size() {
        return this.fieldNames.size();
    }

    int getIndex(String name, TokenType assertType) {
        this.assertType(name, assertType);
        return this.index(name);
    }

    int index(String name) {
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            if (!this.fieldNames.get(i).equals(name)) continue;
            return i;
        }
        throw this.unknownFieldNameException(name);
    }

    List<FieldDefinition> listNonDeprecatedFields() {
        return this.listFields().stream().filter(it -> !it.deprecated()).toList();
    }

    List<FieldDefinition> listFields() {
        return this.fieldNames.stream().map(this.fields::get).toList();
    }

    private void assertType(String name, TokenType assertType) {
        Objects.requireNonNull(name);
        FieldDefinition field = this.fields.get(name);
        if (field == null) {
            throw this.unknownFieldNameException(name);
        }
        if (field.type().isNot(assertType)) {
            throw new IllegalArgumentException("The defined type for '" + name + "' is " + String.valueOf((Object)field.type()) + " not " + String.valueOf((Object)assertType) + ".");
        }
    }

    private IllegalArgumentException unknownFieldNameException(String name) {
        return new IllegalArgumentException("Unknown field: '" + name + "'");
    }

    private static Map<String, FieldDefinition> immutableMapOf(List<FieldDefinition> fields) {
        return Map.copyOf(fields.stream().collect(Collectors.toMap(FieldDefinition::name, it -> it)));
    }
}

