/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.time.Duration;
import java.time.Instant;
import org.opentripplanner.framework.token.Serializer;
import org.opentripplanner.framework.token.TokenDefinition;
import org.opentripplanner.framework.token.TokenType;
import org.opentripplanner.utils.lang.ObjectUtils;

public class TokenBuilder {
    private final TokenDefinition definition;
    private final Object[] values;

    public TokenBuilder(TokenDefinition definition) {
        this.definition = definition;
        this.values = new Object[definition.size()];
    }

    public TokenBuilder withBoolean(String fieldName, boolean v) {
        return this.with(fieldName, TokenType.BOOLEAN, v);
    }

    public TokenBuilder withEnum(String fieldName, Enum<?> v) {
        return this.with(fieldName, TokenType.ENUM, v);
    }

    public TokenBuilder withDuration(String fieldName, Duration v) {
        return this.with(fieldName, TokenType.DURATION, v);
    }

    public TokenBuilder withInt(String fieldName, int v) {
        return this.with(fieldName, TokenType.INT, v);
    }

    public TokenBuilder withString(String fieldName, String v) {
        return this.with(fieldName, TokenType.STRING, v);
    }

    public TokenBuilder withTimeInstant(String fieldName, Instant v) {
        return this.with(fieldName, TokenType.TIME_INSTANT, v);
    }

    public String build() {
        return Serializer.serialize(this.definition, this.values);
    }

    private TokenBuilder with(String fieldName, TokenType type, Object value) {
        int index = this.definition.getIndex(fieldName, type);
        this.values[index] = ObjectUtils.requireNotInitialized((String)fieldName, (Object)this.values[index], (Object)value);
        return this;
    }
}

