/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.framework.token.TokenDefinition;
import org.opentripplanner.framework.token.TokenType;

public class Token {
    private final TokenDefinition definition;
    private final List<Object> fieldValues;

    Token(TokenDefinition definition, List<Object> fieldValues) {
        this.definition = Objects.requireNonNull(definition);
        this.fieldValues = Objects.requireNonNull(fieldValues);
    }

    public int version() {
        return this.definition.version();
    }

    public Optional<Boolean> getBoolean(String fieldName) {
        Boolean value = (Boolean)this.get(fieldName, TokenType.BOOLEAN);
        return Optional.ofNullable(value);
    }

    public Optional<Duration> getDuration(String fieldName) {
        return Optional.ofNullable((Duration)this.get(fieldName, TokenType.DURATION));
    }

    public OptionalInt getInt(String fieldName) {
        Integer v = (Integer)this.get(fieldName, TokenType.INT);
        return v == null ? OptionalInt.empty() : OptionalInt.of(v);
    }

    public Optional<String> getString(String fieldName) {
        return Optional.ofNullable((String)this.get(fieldName, TokenType.STRING));
    }

    public <T extends Enum<T>> Optional<T> getEnum(String fieldName, Class<T> enumClass) {
        try {
            String value = (String)this.get(fieldName, TokenType.ENUM);
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(Enum.valueOf(enumClass, value));
        }
        catch (IllegalArgumentException ignore) {
            return Optional.empty();
        }
    }

    public Optional<Instant> getTimeInstant(String fieldName) {
        return Optional.ofNullable((Instant)this.get(fieldName, TokenType.TIME_INSTANT));
    }

    public String toString() {
        return "(v" + this.version() + ", " + this.fieldValues.stream().map(Objects::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Nullable
    private Object get(String fieldName, TokenType type) {
        return this.fieldValues.get(this.definition.getIndex(fieldName, type));
    }
}

