/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.util.Base64;
import org.opentripplanner.framework.token.TokenDefinition;
import org.opentripplanner.framework.token.TokenFormatterConfiguration;
import org.opentripplanner.framework.token.TokenType;
import org.opentripplanner.utils.text.CharacterEscapeFormatter;

class Serializer {
    private final TokenDefinition definition;
    private final Object[] values;
    private final StringBuilder buf = new StringBuilder();
    private final CharacterEscapeFormatter tokenFormatter = TokenFormatterConfiguration.tokenFormatter();

    private Serializer(TokenDefinition definition, Object[] values) {
        this.definition = definition;
        this.values = values;
    }

    static String serialize(TokenDefinition definition, Object[] values) {
        Serializer s = new Serializer(definition, values);
        s.writeVersion(definition.version());
        for (String fieldName : definition.fieldNames()) {
            s.write(fieldName);
        }
        return s.serialize();
    }

    private String serialize() {
        return Base64.getUrlEncoder().encodeToString(this.buf.toString().getBytes());
    }

    private void write(String fieldName) {
        this.write(fieldName, this.values[this.definition.index(fieldName)]);
    }

    private void write(String fieldName, Object value) {
        TokenType type = this.definition.type(fieldName);
        this.writeString(type.valueToString(value));
    }

    private void writeVersion(int value) {
        this.writeString(TokenType.INT.valueToString(value));
    }

    private void writeString(String value) {
        if (value != null) {
            this.buf.append(this.tokenFormatter.encode(value));
        }
        this.buf.append(TokenFormatterConfiguration.fieldSeparator());
    }
}

