/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.util.Objects;
import org.opentripplanner.framework.token.TokenType;

class FieldDefinition {
    private final String name;
    private final TokenType type;
    private final boolean deprecated;

    private FieldDefinition(String name, TokenType type, boolean deprecated) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.deprecated = deprecated;
    }

    public FieldDefinition(String name, TokenType type) {
        this(name, type, false);
    }

    public String name() {
        return this.name;
    }

    public TokenType type() {
        return this.type;
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDefinition that = (FieldDefinition)o;
        return this.deprecated == that.deprecated && Objects.equals(this.name, that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.deprecated});
    }

    public String toString() {
        return (this.deprecated ? "@deprecated " : "") + this.name + ":" + String.valueOf((Object)this.type);
    }

    public FieldDefinition deprecate() {
        return new FieldDefinition(this.name, this.type, true);
    }
}

