/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.opentripplanner.framework.token.FieldDefinition;
import org.opentripplanner.framework.token.TokenDefinition;
import org.opentripplanner.framework.token.TokenFormatterConfiguration;
import org.opentripplanner.utils.text.CharacterEscapeFormatter;

class Deserializer {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[" + TokenFormatterConfiguration.fieldSeparator() + "]");
    private final List<String> values;

    Deserializer(String token) {
        byte[] bytes = Base64.getUrlDecoder().decode(token);
        CharacterEscapeFormatter tokenFormatter = TokenFormatterConfiguration.tokenFormatter();
        this.values = Stream.of(SPLIT_PATTERN.split(new String(bytes), -1)).map(arg_0 -> ((CharacterEscapeFormatter)tokenFormatter).decode(arg_0)).toList();
    }

    List<Object> deserialize(TokenDefinition definition) {
        try {
            return this.readFields(definition, false);
        }
        catch (Exception ignore) {
            return this.readFields(definition, true);
        }
    }

    private List<Object> readFields(TokenDefinition definition, boolean matchNewVersionPlusOne) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.matchVersion(definition, matchNewVersionPlusOne);
        int index = 1;
        for (FieldDefinition field : definition.listFields()) {
            if (matchNewVersionPlusOne && field.deprecated()) continue;
            Object v = this.read(field, index);
            if (!field.deprecated()) {
                result.add(v);
            }
            ++index;
        }
        return result;
    }

    private void matchVersion(TokenDefinition definition, boolean matchVersionPlusOne) {
        int matchVersion = (matchVersionPlusOne ? 1 : 0) + definition.version();
        int version = this.readVersion();
        if (version != matchVersion) {
            throw new IllegalStateException("Version does not match. Token version: " + version + ", schema version: " + definition.version());
        }
    }

    private Object read(FieldDefinition field, int index) {
        return field.type().stringToValue(this.values.get(index));
    }

    private int readVersion() {
        return Integer.parseInt(this.values.get(0));
    }
}

