/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.time;

import java.time.ZoneId;
import javax.annotation.Nullable;
import org.opentripplanner.utils.logging.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneIdFallback {
    private static final Logger LOG = LoggerFactory.getLogger(ZoneIdFallback.class);
    private static final ZoneId FALLBACK = ZoneId.of("UTC");
    private static final Throttle THROTTLE = Throttle.ofOneMinute();

    public static ZoneId zoneId(@Nullable ZoneId id) {
        if (id == null) {
            THROTTLE.throttle(() -> {
                LOG.warn("Your instance doesn't contain a time zone (which is usually derived from transit data). Assuming {}.", (Object)FALLBACK);
                LOG.warn("Please double-check that transit data was correctly loaded.");
            });
            return FALLBACK;
        }
        return id;
    }
}

