/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.retry;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Predicate;
import org.opentripplanner.framework.retry.OtpRetry;

public class OtpRetryBuilder {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final Duration DEFAULT_INITIAL_RETRYABLE_INTERVAL = Duration.of(1L, ChronoUnit.SECONDS);
    public static final Predicate<Exception> DEFAULT_RETRYABLE_EXCEPTION = e -> true;
    public static final Runnable DEFAULT_ON_RETRY = () -> {};
    private String name;
    private int maxAttempts = 3;
    private Duration initialRetryInterval = DEFAULT_INITIAL_RETRYABLE_INTERVAL;
    private int backoffMultiplier;
    private Predicate<Exception> retryableException = DEFAULT_RETRYABLE_EXCEPTION;
    private Runnable onRetry = DEFAULT_ON_RETRY;

    public OtpRetryBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public OtpRetryBuilder withMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    public OtpRetryBuilder withInitialRetryInterval(Duration initialRetryInterval) {
        this.initialRetryInterval = initialRetryInterval;
        return this;
    }

    public OtpRetryBuilder withBackoffMultiplier(int backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
        return this;
    }

    public OtpRetryBuilder withRetryableException(Predicate<Exception> retryableException) {
        this.retryableException = retryableException;
        return this;
    }

    public OtpRetryBuilder withOnRetry(Runnable onRetry) {
        this.onRetry = onRetry;
        return this;
    }

    public OtpRetry build() {
        return new OtpRetry(this.name, this.maxAttempts, this.initialRetryInterval, this.backoffMultiplier, this.retryableException, this.onRetry);
    }
}

