/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.retry;

import java.time.Duration;
import java.util.function.Predicate;
import org.opentripplanner.framework.retry.OtpRetryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpRetry {
    private static final Logger LOG = LoggerFactory.getLogger(OtpRetry.class);
    private final String name;
    private final int maxAttempts;
    private final Duration initialRetryInterval;
    private final int backoffMultiplier;
    private final Runnable onRetry;
    private final Predicate<Exception> retryableException;

    OtpRetry(String name, int maxAttempts, Duration initialRetryInterval, int backoffMultiplier, Predicate<Exception> retryableException, Runnable onRetry) {
        this.name = name;
        this.maxAttempts = maxAttempts;
        this.initialRetryInterval = initialRetryInterval;
        this.backoffMultiplier = backoffMultiplier;
        this.retryableException = retryableException;
        this.onRetry = onRetry;
    }

    public void execute(Runnable retryable) throws InterruptedException {
        int attempts = 0;
        long sleepTime = this.initialRetryInterval.toMillis();
        while (true) {
            try {
                retryable.run();
                return;
            }
            catch (Exception e) {
                if (!this.retryableException.test(e)) {
                    throw new OtpRetryException("Operation failed with non-retryable exception", e);
                }
                if (++attempts > this.maxAttempts) {
                    throw new OtpRetryException("Operation failed after " + attempts + " attempts", e);
                }
                LOG.info("Operation {} failed with retryable exception: {}. Retrying {}/{} in {} millis", new Object[]{this.name, e.getMessage(), attempts, this.maxAttempts, sleepTime});
                this.onRetry.run();
                Thread.sleep(sleepTime);
                sleepTime *= (long)this.backoffMultiplier;
                continue;
            }
            break;
        }
    }
}

