/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.model;

import java.util.Locale;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.lang.IntUtils;

@Deprecated
public class Units {
    private static final double ONE_MACH = 340.0;

    private Units() {
    }

    public static double reluctance(double value) {
        return Units.normalizedFactor(value, 0.0, Double.MAX_VALUE);
    }

    public static double normalizedFactor(double value, double minValue, double maxValue) {
        DoubleUtils.requireInRange((double)value, (double)minValue, (double)maxValue);
        if (Math.abs(value) < 2.0) {
            return DoubleUtils.roundTo2Decimals((double)value);
        }
        if (Math.abs(value) < 10.0) {
            return DoubleUtils.roundTo1Decimal((double)value);
        }
        return DoubleUtils.roundToZeroDecimals((double)value);
    }

    public static String factorToString(double value) {
        if (Math.abs(value) < 2.0) {
            return String.format(Locale.ROOT, "%.2f", value);
        }
        if (Math.abs(value) < 10.0) {
            return String.format(Locale.ROOT, "%.1f", value);
        }
        return String.format(Locale.ROOT, "%.0f", value);
    }

    public static Double normalizedOptionalFactor(Double value, double minValue, double maxValue) {
        return value == null ? null : Double.valueOf(Units.normalizedFactor(value, minValue, maxValue));
    }

    public static int duration(int seconds) {
        return IntUtils.requireNotNegative((int)seconds);
    }

    public static double speed(double metersPerSecond) {
        if (metersPerSecond < 0.0) {
            throw new IllegalArgumentException("Negative speed not expected: " + metersPerSecond + " m/s");
        }
        if (metersPerSecond < 0.1) {
            return 0.1;
        }
        if (metersPerSecond < 2.0) {
            return DoubleUtils.roundTo2Decimals((double)metersPerSecond);
        }
        if (metersPerSecond < 10.0) {
            return DoubleUtils.roundTo1Decimal((double)metersPerSecond);
        }
        if (metersPerSecond > 340.0) {
            throw new IllegalArgumentException("Are you flying in supersonic speed: " + metersPerSecond + " m/s");
        }
        return DoubleUtils.roundToZeroDecimals((double)metersPerSecond);
    }

    public static double acceleration(double metersPerSecondSquared) {
        if (metersPerSecondSquared < 0.0) {
            throw new IllegalArgumentException("Negative acceleration or deceleration not expected: " + metersPerSecondSquared);
        }
        if (metersPerSecondSquared < 0.1) {
            return 0.1;
        }
        return DoubleUtils.roundTo1Decimal((double)metersPerSecondSquared);
    }

    public static double ratio(double value) {
        return DoubleUtils.requireInRange((double)DoubleUtils.roundTo3Decimals((double)value), (double)0.0, (double)1.0);
    }

    public static int count(int value, int maxValue) {
        return IntUtils.requireInRange((int)value, (int)0, (int)maxValue);
    }
}

