/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.model;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Gram
implements Serializable,
Comparable<Gram> {
    public static final Gram ZERO = new Gram(0L);
    private static final Pattern PATTERN = Pattern.compile("(-?[\\d\\.]+) ?([kmg]*)");
    private static final int GRAM_PRECISION = 1000;
    private static final int KILO_GRAM_PRECISION = 1000000;
    private final long value;

    private Gram(long value) {
        this.value = value;
    }

    private static Gram ofPrecisionDouble(double value) {
        long v = Math.round(value);
        return v == 0L ? ZERO : new Gram(v);
    }

    private static Gram ofPrecisionInt(long value) {
        return value == 0L ? ZERO : new Gram(value);
    }

    public static Gram of(long value) {
        return Gram.ofPrecisionInt(value * 1000L);
    }

    public static Gram of(double value) {
        return Gram.ofPrecisionDouble(value * 1000.0);
    }

    public static Gram of(String value) {
        return Gram.parse(value);
    }

    public static Gram ofNullable(Double value) {
        return value == null ? ZERO : Gram.of(value);
    }

    public Gram plus(Gram g) {
        return new Gram(this.value + g.value);
    }

    public Gram multiply(long multiplier) {
        return new Gram(this.value * multiplier);
    }

    public Gram multiply(double multiplier) {
        return Gram.ofPrecisionDouble((double)this.value * multiplier);
    }

    public Gram dividedBy(long divisor) {
        return Gram.ofPrecisionDouble((double)this.value / (double)divisor);
    }

    public Gram dividedBy(double divisor) {
        return Gram.ofPrecisionDouble((double)this.value / divisor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gram that = (Gram)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    @Override
    public int compareTo(Gram o) {
        return Double.compare(this.value, o.value);
    }

    public String toString() {
        if (this.value % 1000000L == 0L) {
            return this.value / 1000000L + "kg";
        }
        if (this.value % 1000L == 0L) {
            return this.value / 1000L + "g";
        }
        if (Math.abs(this.value) > 1000L) {
            return (double)this.value / 1000.0 + "g";
        }
        return this.value + "mg";
    }

    public double asDouble() {
        return (double)this.value / 1000.0;
    }

    public boolean isZero() {
        return this.value == 0L;
    }

    private static Gram parse(String value) {
        Matcher m = PATTERN.matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException("Parse error! Illegal gram value: '%s'".formatted(value));
        }
        String num = m.group(1);
        String unit = m.group(2);
        double v = Double.parseDouble(num);
        if ("kg".equalsIgnoreCase(unit)) {
            return Gram.ofPrecisionDouble(1000000.0 * v);
        }
        if ("g".equalsIgnoreCase(unit) || unit.isBlank()) {
            return Gram.ofPrecisionDouble(1000.0 * v);
        }
        if ("mg".equalsIgnoreCase(unit)) {
            return Gram.ofPrecisionDouble(v);
        }
        throw new IllegalArgumentException("Parse error! Illegal gram value: '%s'".formatted(value));
    }
}

