/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.model;

import java.io.Serializable;
import java.time.Duration;
import org.opentripplanner.utils.lang.IntUtils;
import org.opentripplanner.utils.lang.OtpNumberFormat;

public final class Cost
implements Serializable,
Comparable<Cost> {
    private static final int CENTI_FACTOR = 100;
    public static final Cost ZERO = new Cost(0);
    public static final Cost ONE_HOUR_WITH_TRANSIT = Cost.fromDuration(Duration.ofHours(1L));
    private final int value;

    private Cost(int value) {
        this.value = IntUtils.requireNotNegative((int)value);
    }

    public static Cost costOfSeconds(int valueInTransitSeconds) {
        return new Cost(valueInTransitSeconds * 100);
    }

    public static Cost costOfSeconds(double valueInTransitSeconds) {
        return new Cost(IntUtils.round((double)(valueInTransitSeconds * 100.0)));
    }

    public static Cost costOfCentiSeconds(int valueInTransitCentiSeconds) {
        return new Cost(valueInTransitCentiSeconds);
    }

    public static Cost costOfMinutes(int value) {
        return Cost.costOfSeconds(value * 60);
    }

    public static Cost fromDuration(Duration value) {
        return Cost.costOfSeconds((double)value.toMillis() / 1000.0);
    }

    public int toSeconds() {
        return IntUtils.round((double)(this.value / 100));
    }

    public int toCentiSeconds() {
        return this.value;
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public Duration asDuration() {
        return this.isZero() ? Duration.ZERO : Duration.ofMillis(this.value * 10);
    }

    public Cost plus(Cost other) {
        return new Cost(this.value + other.value);
    }

    public Cost minus(Cost other) {
        return new Cost(this.value - other.value);
    }

    public Cost multiply(int factor) {
        return new Cost(this.value * factor);
    }

    public Cost multiply(double factor) {
        return new Cost(IntUtils.round((double)((double)this.value * factor)));
    }

    public boolean greaterThan(Cost other) {
        return this.value > other.value;
    }

    public boolean greaterOrEq(Cost other) {
        return this.value >= other.value;
    }

    public boolean lessThan(Cost other) {
        return this.value < other.value;
    }

    public boolean lessOrEq(Cost other) {
        return this.value <= other.value;
    }

    public String toString() {
        return OtpNumberFormat.formatCostCenti((int)this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cost that = (Cost)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(Cost o) {
        return this.value - o.value;
    }
}

