/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.io;

import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.slf4j.Logger;

public class OtpHttpClientFactory
implements AutoCloseable {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_TTL = Duration.ofMinutes(1L);
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 25;
    private final CloseableHttpClient httpClient;

    public OtpHttpClientFactory() {
        this(DEFAULT_TIMEOUT, DEFAULT_TTL);
    }

    public OtpHttpClientFactory(int maxConnections) {
        this(DEFAULT_TIMEOUT, DEFAULT_TTL, maxConnections);
    }

    public OtpHttpClientFactory(Duration timeout, Duration connectionTtl) {
        this(timeout, connectionTtl, 25);
    }

    private OtpHttpClientFactory(Duration timeout, Duration connectionTtl, int maxConnections) {
        Objects.requireNonNull(timeout);
        Objects.requireNonNull(connectionTtl);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.of((Duration)timeout)).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setMaxConnTotal(maxConnections).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.of((Duration)timeout)).setConnectTimeout(Timeout.of((Duration)timeout)).setTimeToLive(TimeValue.of((Duration)connectionTtl)).build()).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setUserAgent("OpenTripPlanner").setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(OtpHttpClientFactory.requestConfig(timeout));
        this.httpClient = httpClientBuilder.build();
    }

    public OtpHttpClient create(Logger logger) {
        return new OtpHttpClient(this.httpClient, logger);
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new OtpHttpClientException(e);
        }
    }

    private static RequestConfig requestConfig(Duration timeout) {
        return RequestConfig.custom().setResponseTimeout(Timeout.of((Duration)timeout)).setConnectionRequestTimeout(Timeout.of((Duration)timeout)).setProtocolUpgradeEnabled(false).build();
    }
}

