/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.slf4j.Logger;

public class OtpHttpClient {
    private final CloseableHttpClient httpClient;
    private final Logger log;

    OtpHttpClient(CloseableHttpClient httpClient, Logger logger) {
        this.httpClient = httpClient;
        this.log = logger;
    }

    public List<Header> getHeaders(URI uri, Duration timeout, Map<String, String> requestHeaderValues) {
        return (List)this.executeAndMapWithResponseHandler((HttpUriRequestBase)new HttpHead(uri), timeout, requestHeaderValues, response -> {
            if (OtpHttpClient.isFailedRequest((HttpResponse)response)) {
                this.logResponse(response);
                this.log.warn("Headers of resource {} unavailable. HTTP error code {}", (Object)OtpHttpClient.sanitizeUri(uri), (Object)response.getCode());
                return Collections.emptyList();
            }
            return Arrays.stream(response.getHeaders()).toList();
        });
    }

    public <T> T getAndMapAsJsonObject(URI uri, Map<String, String> headers, ObjectMapper objectMapper, Class<T> clazz) {
        return this.getAndMapAsJsonObject(uri, null, headers, objectMapper, clazz);
    }

    public <T> T getAndMapAsJsonObject(URI uri, Duration timeout, Map<String, String> headers, ObjectMapper objectMapper, Class<T> clazz) {
        return (T)this.getAndMap(uri, timeout, headers, is -> {
            try {
                return objectMapper.readValue(is, clazz);
            }
            catch (Exception e) {
                throw new OtpHttpClientException(e);
            }
        });
    }

    public JsonNode getAndMapAsJsonNode(URI uri, Map<String, String> headers, ObjectMapper objectMapper) {
        return this.getAndMapAsJsonNode(uri, null, headers, objectMapper);
    }

    public JsonNode getAndMapAsJsonNode(URI uri, Duration timeout, Map<String, String> headers, ObjectMapper objectMapper) {
        return this.getAndMap(uri, timeout, headers, is -> {
            try {
                return objectMapper.readTree(is);
            }
            catch (Exception e) {
                throw new OtpHttpClientException(e);
            }
        });
    }

    public <T> T getAndMap(URI uri, Map<String, String> headers, ResponseMapper<T> contentMapper) {
        return this.getAndMap(uri, null, headers, contentMapper);
    }

    public <T> T getAndMap(URI uri, Duration timeout, Map<String, String> headers, ResponseMapper<T> contentMapper) {
        return this.sendAndMap((HttpUriRequestBase)new HttpGet(uri), uri, timeout, headers, contentMapper);
    }

    public <T> T postJsonAndMap(URI uri, JsonNode jsonBody, Duration timeout, Map<String, String> headers, ResponseMapper<T> contentMapper) {
        HttpPost request = new HttpPost(uri);
        request.setEntity((HttpEntity)new StringEntity(jsonBody.toString()));
        request.setHeader("Content-Type", (Object)ContentType.APPLICATION_JSON);
        return this.sendAndMap((HttpUriRequestBase)request, uri, timeout, headers, contentMapper);
    }

    public <T> T postXmlAndMap(String url, String xmlData, Duration timeout, Map<String, String> requestHeaderValues, ResponseMapper<T> contentMapper) {
        HttpPost httppost = new HttpPost(url);
        if (xmlData != null) {
            httppost.setEntity((HttpEntity)new StringEntity(xmlData, ContentType.APPLICATION_XML));
        }
        return this.executeAndMap((HttpUriRequestBase)httppost, timeout, requestHeaderValues, contentMapper);
    }

    public <T> T executeAndMap(HttpUriRequestBase httpRequest, Duration timeout, Map<String, String> headers, ResponseMapper<T> contentMapper) {
        return this.executeAndMapWithResponseHandler(httpRequest, timeout, headers, response -> this.mapResponse(response, contentMapper));
    }

    public <T> Optional<T> executeAndMapOptional(HttpUriRequestBase httpRequest, Duration timeout, Map<String, String> headers, ResponseMapper<T> contentMapper) {
        return (Optional)this.executeAndMapWithResponseHandler(httpRequest, timeout, headers, response -> {
            if (response.getCode() == 204) {
                return Optional.empty();
            }
            return Optional.of(this.mapResponse(response, contentMapper));
        });
    }

    public InputStream getAsInputStream(URI uri, Duration timeout, Map<String, String> requestHeaders) throws IOException {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(timeout);
        Objects.requireNonNull(requestHeaders);
        HttpGet httpRequest = new HttpGet(uri);
        httpRequest.setConfig(OtpHttpClient.requestConfig(timeout));
        requestHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequestBase)httpRequest).addHeader(arg_0, arg_1));
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpRequest);
        if (OtpHttpClient.isFailedRequest((HttpResponse)response)) {
            throw new IOException("Service unavailable: " + String.valueOf(uri) + ". HTTP status code: " + response.getCode() + " - " + response.getReasonPhrase());
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new IOException("HTTP response message entity is empty for url: " + String.valueOf(uri));
        }
        return entity.getContent();
    }

    protected <T> T executeAndMapWithResponseHandler(HttpUriRequestBase httpRequest, Duration timeout, Map<String, String> requestHeaders, HttpClientResponseHandler<? extends T> responseHandler) {
        Objects.requireNonNull(requestHeaders);
        if (timeout != null) {
            httpRequest.setConfig(OtpHttpClient.requestConfig(timeout));
        }
        requestHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequestBase)httpRequest).addHeader(arg_0, arg_1));
        try {
            return (T)this.httpClient.execute((ClassicHttpRequest)httpRequest, responseHandler);
        }
        catch (IOException e) {
            throw new OtpHttpClientException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T mapResponse(ClassicHttpResponse response, ResponseMapper<T> contentMapper) {
        if (OtpHttpClient.isFailedRequest((HttpResponse)response)) {
            this.logResponse(response);
            throw new OtpHttpClientException("HTTP request failed with status code " + response.getCode());
        }
        if (response.getEntity() == null) {
            throw new OtpHttpClientException("HTTP request failed: empty response");
        }
        try (InputStream is = response.getEntity().getContent();){
            if (is == null) {
                throw new OtpHttpClientException("HTTP request failed: empty response");
            }
            T t = contentMapper.apply(is);
            return t;
        }
        catch (Exception e) {
            throw new OtpHttpClientException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T sendAndMap(HttpUriRequestBase request, URI uri, Duration timeout, Map<String, String> headers, ResponseMapper<T> contentMapper) {
        URL downloadUrl;
        try {
            downloadUrl = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new OtpHttpClientException(e);
        }
        String proto = downloadUrl.getProtocol();
        if (proto.equals("http")) return this.executeAndMap(request, timeout, headers, contentMapper);
        if (proto.equals("https")) {
            return this.executeAndMap(request, timeout, headers, contentMapper);
        }
        try (InputStream is = downloadUrl.openStream();){
            T t = contentMapper.apply(is);
            return t;
        }
        catch (Exception e) {
            throw new OtpHttpClientException(e);
        }
    }

    private static RequestConfig requestConfig(Duration timeout) {
        return RequestConfig.custom().setResponseTimeout(Timeout.of((Duration)timeout)).setConnectionRequestTimeout(Timeout.of((Duration)timeout)).setProtocolUpgradeEnabled(false).build();
    }

    private static boolean isFailedRequest(HttpResponse response) {
        return response.getCode() < 200 || response.getCode() >= 300;
    }

    private static String sanitizeUri(URI uri) {
        return uri.toString().replace("?" + uri.getQuery(), "");
    }

    private void logResponse(ClassicHttpResponse response) {
        try {
            if (this.log.isTraceEnabled() && response.getEntity() != null && response.getEntity().getContent() != null) {
                HttpEntity entity = response.getEntity();
                String content = new BufferedReader(new InputStreamReader(entity.getContent())).lines().collect(Collectors.joining("\n"));
                this.log.trace("HTTP request failed with status code {}: \n{}", (Object)response.getCode(), (Object)content);
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
        }
    }

    @FunctionalInterface
    public static interface ResponseMapper<R> {
        public R apply(InputStream var1) throws Exception;
    }
}

