/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.function.Function;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDataListDownloader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonDataListDownloader.class);
    private final String jsonParsePath;
    private final Map<String, String> headers;
    private final Function<JsonNode, T> elementParser;
    private final String url;
    private final OtpHttpClient otpHttpClient;

    public JsonDataListDownloader(String url, String jsonParsePath, Function<JsonNode, T> elementParser, Map<String, String> headers) {
        this(url, jsonParsePath, elementParser, headers, new OtpHttpClientFactory().create(LOG));
    }

    public JsonDataListDownloader(String url, String jsonParsePath, Function<JsonNode, T> elementParser, Map<String, String> headers, OtpHttpClient OtpHttpClient2) {
        this.url = Objects.requireNonNull(url);
        this.jsonParsePath = Objects.requireNonNull(jsonParsePath);
        this.headers = Objects.requireNonNull(headers);
        this.elementParser = Objects.requireNonNull(elementParser);
        this.otpHttpClient = Objects.requireNonNull(OtpHttpClient2);
    }

    public List<T> download() {
        if (this.url == null) {
            LOG.warn("Cannot download updates, because url is null!");
            return null;
        }
        try {
            return this.otpHttpClient.getAndMap(URI.create(this.url), this.headers, is -> {
                try {
                    return this.parseJSON(is);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Error parsing feed from {}", (Object)this.url, (Object)e);
                }
                catch (JsonProcessingException e) {
                    LOG.warn("Error parsing feed from {} (bad JSON of some sort)", (Object)this.url, (Object)e);
                }
                catch (IOException e) {
                    LOG.warn("Error reading feed from {}", (Object)this.url, (Object)e);
                }
                return null;
            });
        }
        catch (OtpHttpClientException e) {
            LOG.warn("Failed to get data from url {}", (Object)this.url);
            return null;
        }
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner scanner = new Scanner(is).useDelimiter("\\A");){
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private List<T> parseJSON(InputStream dataStream) throws IllegalArgumentException, IOException {
        ArrayList<T> out = new ArrayList<T>();
        String rentalString = JsonDataListDownloader.convertStreamToString(dataStream);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(rentalString);
        if (!this.jsonParsePath.isEmpty()) {
            String[] parseElement;
            String delimiter = "/";
            for (String s : parseElement = this.jsonParsePath.split(delimiter)) {
                rootNode = rootNode.path(s);
            }
            if (rootNode.isMissingNode()) {
                throw new IllegalArgumentException("Could not find jSON elements " + this.jsonParsePath);
            }
        }
        for (JsonNode node : rootNode) {
            if (node == null) continue;
            try {
                T parsedElement = this.elementParser.apply(node);
                if (parsedElement == null) continue;
                out.add(parsedElement);
            }
            catch (Exception e) {
                LOG.error("Could not process element in JSON list downloaded from {}", (Object)this.url, (Object)e);
            }
        }
        return out;
    }
}

