/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.io;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hc.core5.http.ContentType;

public final class HttpUtils {
    public static final Object TEXT_PLAIN = ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8);
    public static final String APPLICATION_X_PROTOBUF = "application/x-protobuf";
    private static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String HEADER_HOST = "Host";

    private HttpUtils() {
    }

    public static String getBaseAddress(UriInfo uri, HttpHeaders headers) {
        String protocol = headers.getRequestHeader(HEADER_X_FORWARDED_PROTO) != null ? (String)headers.getRequestHeader(HEADER_X_FORWARDED_PROTO).getFirst() : uri.getRequestUri().getScheme();
        Object host = headers.getRequestHeader(HEADER_X_FORWARDED_HOST) != null ? HttpUtils.extractHost((String)headers.getRequestHeader(HEADER_X_FORWARDED_HOST).getFirst()) : (headers.getRequestHeader(HEADER_HOST) != null ? (String)headers.getRequestHeader(HEADER_HOST).getFirst() : uri.getBaseUri().getHost() + ":" + uri.getBaseUri().getPort());
        return protocol + "://" + (String)host;
    }

    private static String extractHost(String xForwardedFor) {
        return Arrays.stream(xForwardedFor.split(",")).map(String::strip).findFirst().get();
    }
}

