/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class FileUtils {
    public static String readFile(File file) {
        String string;
        FileInputStream is = new FileInputStream(file);
        try {
            string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        is.close();
        return string;
    }

    public static void writeFile(File file, String doc) {
        try (FileOutputStream fileOut = new FileOutputStream(file);){
            PrintWriter out = new PrintWriter(fileOut);
            out.write(doc);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void assertFileEquals(String expectedDoc, File newFile) {
        int j;
        String resultDoc = FileUtils.readFile(newFile);
        String[] expectedLines = expectedDoc.split("[\n\r]+");
        String[] resultLines = resultDoc.split("[\n\r]+");
        int i = 0;
        for (j = 0; i < expectedLines.length && j < resultLines.length; ++i, ++j) {
            String result;
            while (expectedLines[i].isBlank()) {
                ++i;
            }
            while (resultLines[j].isBlank()) {
                ++j;
            }
            String expected = expectedLines[i].stripTrailing();
            if (expected.equals(result = resultLines[j].stripTrailing())) continue;
            throw new IllegalStateException("The file (%s) differ from the expected document.\n  Expected (line: %3d): %s\n  Result   (line: %3d): %s\n".formatted(newFile.getAbsolutePath(), i, expected, j, result));
        }
        if (i < expectedLines.length) {
            throw new IllegalStateException("Lines missing in new file (" + newFile.getAbsolutePath() + "): " + expectedLines[i]);
        }
        if (j < resultLines.length) {
            throw new IllegalStateException("Lines not expected in new file (" + newFile.getAbsolutePath() + "): " + resultLines[j]);
        }
    }
}

