/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.i18n;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;

public class TranslatedString
implements I18NString,
Serializable {
    private static final HashMap<Map<String, String>, I18NString> translationCache = new HashMap();
    private final Map<String, String> translations = new HashMap<String, String>();

    private TranslatedString(Map<String, String> translations) {
        for (Map.Entry<String, String> i : translations.entrySet()) {
            if (i.getKey() == null) {
                this.translations.put(null, i.getValue());
                continue;
            }
            this.translations.put(i.getKey().toLowerCase(), i.getValue());
        }
    }

    public static I18NString getI18NString(String untranslated, String ... translations) {
        if (translations.length % 2 != 0) {
            throw new IllegalStateException("An even number of translations must be supplied.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(null, untranslated);
        for (int i = 0; i < translations.length - 1; i += 2) {
            map.put(translations[i], translations[i + 1]);
        }
        return TranslatedString.getI18NString(map, false, false);
    }

    public static I18NString getI18NString(Map<String, String> translations, boolean intern, boolean forceTranslatedString) {
        boolean onlySingleUntranslatedLanguage;
        if (translations.isEmpty()) {
            throw new IllegalArgumentException("At least one translation must be provided");
        }
        if (translationCache.containsKey(translations)) {
            return translationCache.get(translations);
        }
        boolean allValuesEqual = new HashSet<String>(translations.values()).size() == 1;
        String firstLanguage = translations.keySet().iterator().next();
        boolean bl = onlySingleUntranslatedLanguage = translations.size() == 1 && (firstLanguage == null || firstLanguage.isBlank());
        I18NString ret = forceTranslatedString && !onlySingleUntranslatedLanguage ? new TranslatedString(translations) : (allValuesEqual ? new NonLocalizedString(translations.values().iterator().next()) : new TranslatedString(translations));
        if (intern) {
            translationCache.put(translations, ret);
        }
        return ret;
    }

    public int hashCode() {
        return Objects.hash(this.translations);
    }

    public boolean equals(Object other) {
        return other instanceof TranslatedString && this.translations.equals(((TranslatedString)other).translations);
    }

    @Override
    public String toString() {
        return this.translations.containsKey(null) ? this.translations.get(null) : this.translations.values().iterator().next();
    }

    public Collection<String> getLanguages() {
        return this.translations.keySet();
    }

    public List<Map.Entry<String, String>> getTranslations() {
        return new ArrayList<Map.Entry<String, String>>(this.translations.entrySet());
    }

    @Override
    public String toString(Locale locale) {
        String language = null;
        if (locale != null) {
            language = locale.getLanguage().toLowerCase();
        }
        return this.translations.containsKey(language) ? this.translations.get(language) : this.toString();
    }
}

