/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.i18n;

import java.util.Locale;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.NonLocalizedString;

public interface I18NString {
    public static boolean hasValue(@Nullable I18NString value) {
        return !I18NString.hasNoValue(value);
    }

    public static boolean hasNoValue(@Nullable I18NString value) {
        return value == null || value.toString().isBlank();
    }

    public String toString();

    public String toString(Locale var1);

    public static I18NString assertHasValue(@Nullable I18NString value) {
        if (I18NString.hasNoValue(value)) {
            throw new IllegalArgumentException("Value can not be null, empty or just whitespace: " + (String)(value == null ? "null" : "'" + String.valueOf(value) + "'"));
        }
        return value;
    }

    public static I18NString of(String value) {
        return new NonLocalizedString(value);
    }
}

