/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.graphql;

import graphql.schema.DataFetchingEnvironment;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;

public class GraphQLUtils {
    @Nullable
    public static String getTranslation(@Nullable I18NString input, DataFetchingEnvironment environment) {
        if (input == null) {
            return null;
        }
        return input.toString(GraphQLUtils.getLocale(environment));
    }

    public static Locale getLocale(DataFetchingEnvironment environment) {
        Object localeString = environment.getArgument("language");
        if (localeString != null) {
            return Locale.forLanguageTag((String)localeString);
        }
        return GraphQLUtils.getLocaleFromEnvironment(environment);
    }

    public static Locale getLocale(DataFetchingEnvironment environment, @Nullable String localeString) {
        if (localeString != null) {
            return Locale.forLanguageTag(localeString);
        }
        return GraphQLUtils.getLocaleFromEnvironment(environment);
    }

    public static Locale getLocale(DataFetchingEnvironment environment, @Nullable Locale locale) {
        if (locale != null) {
            return locale;
        }
        return GraphQLUtils.getLocaleFromEnvironment(environment);
    }

    public static Locale getLocaleFromEnvironment(DataFetchingEnvironment environment) {
        Locale envLocale = environment.getLocale();
        Optional<Locale> localContextLocale = GraphQLUtils.getLocalContextLocale(environment);
        return localContextLocale.orElse(envLocale);
    }

    private static Optional<Locale> getLocalContextLocale(DataFetchingEnvironment environment) {
        Map localContext = (Map)environment.getLocalContext();
        if (localContext == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Locale)localContext.get("locale"));
    }
}

