/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WordList {
    private final List<String> words = new ArrayList<String>();

    private WordList() {
    }

    public static WordList of() {
        return new WordList();
    }

    public static WordList of(String word) {
        return new WordList().add(word);
    }

    public static WordList of(String ... words) {
        return new WordList().add(words);
    }

    public WordList add(String word) {
        this.words.add(word);
        return this;
    }

    public WordList add(int value) {
        this.words.add(Integer.toString(value));
        return this;
    }

    public WordList add(String ... words) {
        this.words.addAll(Arrays.asList(words));
        return this;
    }

    public String toString() {
        switch (this.words.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.words.getFirst();
            }
        }
        StringBuilder buf = new StringBuilder(this.words.get(0));
        for (int i = 1; i < this.words.size() - 1; ++i) {
            buf.append(", ").append(this.words.get(i));
        }
        buf.append(" and ").append(this.words.getLast());
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.words.isEmpty();
    }
}

