/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import org.opentripplanner.framework.application.LogMDCSupport;
import org.opentripplanner.framework.concurrent.LogMDCRunnableDecorator;

public class OtpRequestThreadFactory
implements ThreadFactory {
    private final ThreadFactory delegate;

    private OtpRequestThreadFactory(ThreadFactory delegate) {
        this.delegate = delegate;
    }

    public static ThreadFactory of(String nameFormat) {
        ThreadFactory defaultFactory = new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
        return new OtpRequestThreadFactory(defaultFactory);
    }

    @Override
    public Thread newThread(Runnable r) {
        if (LogMDCSupport.isRequestTracingInLoggingEnabled()) {
            return this.delegate.newThread(new LogMDCRunnableDecorator(r));
        }
        return this.delegate.newThread(r);
    }
}

