/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.application;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTPRequestTimeoutException
extends RuntimeException {
    private static final Logger LOG = LoggerFactory.getLogger(OTPRequestTimeoutException.class);
    public static final String MESSAGE = "TIMEOUT! The request is too resource intensive.";

    @Override
    public String getMessage() {
        return MESSAGE;
    }

    public static void checkForTimeout() {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            OTPRequestTimeoutException.logDebug();
            throw new OTPRequestTimeoutException();
        }
    }

    private static void logDebug() {
        StackTraceElement[] st;
        if (LOG.isDebugEnabled() && (st = Thread.currentThread().getStackTrace()).length > 5) {
            LOG.debug("checkForTimeout() - Thread {} is interrupted!\n    {}\n    {}\n    {}", new Object[]{Thread.currentThread().getName(), st[3], st[4], st[5]});
        }
    }
}

