/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.application;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OTPFeature {
    AlertMetrics(false, false, "Starts a background thread to continuously publish metrics about alerts. Needs to be enabled together with `ActuatorAPI`."),
    APIServerInfo(true, false, "Enable the server info endpoint."),
    APIUpdaterStatus(true, false, "Enable endpoint for graph updaters status."),
    IncludeEmptyRailStopsInTransfers(false, false, "Turning this on guarantees that Rail stops without scheduled departures still get included\nwhen generating transfers using `ConsiderPatternsForDirectTransfers`. It is common for stops\nto be assign at real-time for Rail. Turning this on will help to avoid dropping transfers which\nare needed, when the stop is in use later. Turning this on, if\nConsiderPatternsForDirectTransfers is off has no effect.\n"),
    ConsiderPatternsForDirectTransfers(true, false, "Enable limiting transfers so that there is only a single transfer to each pattern."),
    DebugUi(true, false, "Enable the debug GraphQL client and web UI and located at the root of the web server as well as the debug map tiles it uses.\nBe aware that the map tiles are not a stable API and can change without notice.\nUse the [vector tiles feature](sandbox/MapboxVectorTilesApi.md) if you want a stable map tiles API.\n"),
    ExtraTransferLegOnSameStop(false, false, "Should there be a transfer leg when transferring on the very same stop. Note that for in-seat/interlined transfers no transfer leg will be generated."),
    FloatingBike(true, false, "Enable floating bike routing."),
    GtfsGraphQlApi(true, false, "Enable the [GTFS GraphQL API](apis/GTFS-GraphQL-API.md)."),
    MinimumTransferTimeIsDefinitive(false, false, "If the minimum transfer time is a lower bound (default) or the definitive time for the transfer. Set this to `true` if you want to set a transfer time lower than what OTP derives from OSM data."),
    OptimizeTransfers(true, false, "OTP will inspect all itineraries found and optimize where (which stops) the transfer will happen. Waiting time, priority and guaranteed transfers are taken into account."),
    ParallelRouting(false, false, "Enable performing parts of the trip planning in parallel."),
    TransferConstraints(true, false, "Enforce transfers to happen according to the _transfers.txt_ (GTFS) and Interchanges (NeTEx). Turning this _off_ will increase the routing performance a little."),
    TransmodelGraphQlApi(true, true, "Enable the [Transmodel (NeTEx) GraphQL API](apis/TransmodelApi.md)."),
    ActuatorAPI(false, true, "Endpoint for actuators (service health status)."),
    AsyncGraphQLFetchers(false, false, "Whether the @async annotation in the GraphQL schema should lead to the fetch being executed asynchronously. This allows batch or alias queries to run in parallel at the cost of consuming extra threads."),
    WaitForGraphUpdateInPollingUpdaters(true, false, "Make all polling updaters wait for graph updates to complete before finishing. If this is not enabled, the updaters will finish after submitting the task to update the graph."),
    Emission(false, true, "Enable the emission sandbox module."),
    DataOverlay(false, true, "Enable usage of data overlay when calculating costs for the street network."),
    DebugRasterTiles(false, true, "Enable debug raster tile API."),
    FaresV2(false, true, "Enable import of GTFS-Fares v2 data."),
    FlexRouting(false, true, "Enable FLEX routing."),
    GoogleCloudStorage(false, true, "Enable Google Cloud Storage integration."),
    MultiCriteriaGroupMaxFilter(false, false, "Keep the best itinerary with respect to each criteria used in the transit-routing search. For example the itinerary with the lowest cost, fewest transfers, and each unique transit-group (transit-group-priority) is kept, even if the max-limit is exceeded. This is turned off by default for now, until this feature is well tested."),
    RealtimeResolver(false, true, "When routing with ignoreRealtimeUpdates=true, add an extra step which populates results with real-time data"),
    ReportApi(false, true, "Enable the report API."),
    SandboxAPIGeocoder(false, true, "Enable the Geocoder API."),
    SandboxAPIMapboxVectorTilesApi(false, true, "Enable Mapbox vector tiles API."),
    SandboxAPIParkAndRideApi(false, true, "Enable park-and-ride endpoint."),
    Sorlandsbanen(false, true, "Include train S\u00f8rlandsbanen in results when searching in south of Norway. Only relevant in Norway."),
    TransferAnalyzer(false, true, "Analyze transfers during graph build."),
    TriasApi(false, true, "TRIAS API.");

    private static final Object TEST_LOCK;
    private static final Logger LOG;
    private final boolean enabledByDefault;
    private final boolean sandbox;
    private boolean enabled;
    private final String doc;

    private OTPFeature(boolean defaultEnabled, boolean sandbox, String doc) {
        this.enabledByDefault = defaultEnabled;
        this.enabled = defaultEnabled;
        this.sandbox = sandbox;
        this.doc = doc;
    }

    public static void enableFeatures(Map<OTPFeature, Boolean> map) {
        map.forEach(OTPFeature::set);
    }

    public static void logFeatureSetup() {
        LOG.info("Features turned on: \n\t{}", (Object)OTPFeature.valuesAsString(true));
        LOG.info("Features turned off: \n\t{}", (Object)OTPFeature.valuesAsString(false));
    }

    public void testOn(Runnable task) {
        this.testEnabled(true, task);
    }

    public void testOff(Runnable task) {
        this.testEnabled(false, task);
    }

    public boolean isOn() {
        return this.enabled;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public boolean isOff() {
        return !this.enabled;
    }

    @Nullable
    public <T> T isOnElseNull(Supplier<T> supplier) {
        return this.isOn() ? (T)supplier.get() : null;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public String doc() {
        return this.doc;
    }

    private void set(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEnabled(boolean enabled, Runnable task) {
        Object object = TEST_LOCK;
        synchronized (object) {
            boolean originalValue = this.enabled;
            try {
                this.set(enabled);
                task.run();
            }
            finally {
                this.set(originalValue);
            }
        }
    }

    private static String valuesAsString(boolean enabled) {
        return Arrays.stream(OTPFeature.values()).filter(it -> it.enabled == enabled).map(Enum::name).collect(Collectors.joining("\n\t"));
    }

    static {
        TEST_LOCK = new Object();
        LOG = LoggerFactory.getLogger(OTPFeature.class);
    }
}

