/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.application;

import java.util.Map;
import javax.annotation.Nullable;
import org.opentripplanner.utils.lang.StringUtils;
import org.slf4j.MDC;

public class LogMDCSupport {
    private static boolean enabled = false;

    private LogMDCSupport() {
    }

    public static void enable() {
        enabled = true;
    }

    public static boolean isRequestTracingInLoggingEnabled() {
        return enabled;
    }

    public static void putLocal(String key, String value) {
        if (enabled && StringUtils.hasValue((String)key)) {
            if (StringUtils.hasValue((String)value)) {
                MDC.put((String)key, (String)value);
            } else {
                MDC.remove((String)key);
            }
        }
    }

    public static void removeLocal(String key) {
        if (enabled && StringUtils.hasValue((String)key)) {
            MDC.remove((String)key);
        }
    }

    public static String getLocalValue(String logKey) {
        return MDC.get((String)logKey);
    }

    public static Map<String, String> getContext() {
        return enabled ? MDC.getCopyOfContextMap() : Map.of();
    }

    public static void setLocal(@Nullable Map<String, String> parentContextMap) {
        if (enabled && parentContextMap != null && !parentContextMap.isEmpty()) {
            MDC.setContextMap(parentContextMap);
        }
    }

    public static void clearLocal() {
        if (enabled) {
            MDC.clear();
        }
    }
}

