/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.application;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationShutdownSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationShutdownSupport.class);

    private ApplicationShutdownSupport() {
    }

    public static Optional<Thread> addShutdownHook(String hookName, Runnable shutdownHook) {
        Thread shutdownThread = new Thread(shutdownHook, hookName);
        try {
            LOG.info("Adding shutdown hook '{}'.", (Object)hookName);
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            return Optional.of(shutdownThread);
        }
        catch (IllegalStateException ignore) {
            LOG.info("OTP is already shutting down, running shutdown hook '{}' immediately.", (Object)hookName);
            shutdownThread.start();
            return Optional.empty();
        }
    }

    public static void removeShutdownHook(Thread shutdownThread) {
        LOG.info("Removing shutdown hook '{}'.", (Object)shutdownThread.getName());
        Runtime.getRuntime().removeShutdownHook(shutdownThread);
    }
}

