/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehiclerentalservicedirectory.api;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.NetworkParameters;
import org.opentripplanner.updater.spi.HttpHeaders;

public class VehicleRentalServiceDirectoryFetcherParameters {
    public static final String DEFAULT_NETWORK_NAME = "default-network";
    private final URI url;
    private final String sourcesName;
    private final String sourceUrlName;
    private final String sourceNetworkName;
    private final HttpHeaders headers;
    private final String language;
    private final Map<String, NetworkParameters> parametersForNetwork;
    @Nullable
    private final NetworkParameters defaultNetwork;

    public VehicleRentalServiceDirectoryFetcherParameters(URI url, String sourcesName, String updaterUrlName, String networkName, String language, HttpHeaders headers, Collection<NetworkParameters> networkParameters) {
        this.url = url;
        this.sourcesName = sourcesName;
        this.sourceUrlName = updaterUrlName;
        this.sourceNetworkName = networkName;
        this.language = language;
        this.headers = headers;
        this.parametersForNetwork = networkParameters.stream().collect(Collectors.toMap(NetworkParameters::network, it -> it));
        this.defaultNetwork = this.parametersForNetwork.get(DEFAULT_NETWORK_NAME);
    }

    public URI getUrl() {
        return this.url;
    }

    public String getSourcesName() {
        return this.sourcesName;
    }

    public String getSourceUrlName() {
        return this.sourceUrlName;
    }

    public String getSourceNetworkName() {
        return this.sourceNetworkName;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String getLanguage() {
        return this.language;
    }

    public Optional<NetworkParameters> networkParameters(String network) {
        return Optional.ofNullable(this.parametersForNetwork.getOrDefault(network, this.defaultNetwork));
    }
}

