/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehiclerentalservicedirectory;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opentripplanner.ext.vehiclerentalservicedirectory.VehicleRentalParameters;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.NetworkParameters;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.VehicleRentalServiceDirectoryFetcherParameters;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.framework.json.JsonUtils;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.updater.spi.GraphUpdater;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdater;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSource;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSourceFactory;
import org.opentripplanner.updater.vehicle_rental.datasources.params.GbfsVehicleRentalDataSourceParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.params.RentalPickupType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRentalServiceDirectoryFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleRentalServiceDirectoryFetcher.class);
    private static final Duration DEFAULT_FREQUENCY = Duration.ofSeconds(15L);
    private final VertexLinker vertexLinker;
    private final VehicleRentalRepository repository;
    private final OtpHttpClientFactory otpHttpClientFactory;

    public VehicleRentalServiceDirectoryFetcher(VertexLinker vertexLinker, VehicleRentalRepository repository, OtpHttpClientFactory otpHttpClientFactory) {
        this.vertexLinker = vertexLinker;
        this.repository = repository;
        this.otpHttpClientFactory = otpHttpClientFactory;
    }

    public static List<GraphUpdater> createUpdatersFromEndpoint(VehicleRentalServiceDirectoryFetcherParameters parameters, VertexLinker vertexLinker, VehicleRentalRepository repository) {
        LOG.info("Fetching list of updaters from {}", (Object)parameters.getUrl());
        JsonNode sources = VehicleRentalServiceDirectoryFetcher.listSources(parameters);
        if (sources.isEmpty()) {
            return List.of();
        }
        int maxHttpConnections = sources.size();
        OtpHttpClientFactory otpHttpClientFactory = new OtpHttpClientFactory(maxHttpConnections);
        VehicleRentalServiceDirectoryFetcher serviceDirectory = new VehicleRentalServiceDirectoryFetcher(vertexLinker, repository, otpHttpClientFactory);
        return serviceDirectory.createUpdatersFromEndpoint(parameters, sources);
    }

    public List<GraphUpdater> createUpdatersFromEndpoint(VehicleRentalServiceDirectoryFetcherParameters parameters, JsonNode sources) {
        return this.fetchUpdaterInfoFromDirectoryAndCreateUpdaters(VehicleRentalServiceDirectoryFetcher.buildListOfNetworksFromConfig(parameters, sources));
    }

    private static List<GbfsVehicleRentalDataSourceParameters> buildListOfNetworksFromConfig(VehicleRentalServiceDirectoryFetcherParameters parameters, JsonNode sources) {
        ArrayList<GbfsVehicleRentalDataSourceParameters> dataSources = new ArrayList<GbfsVehicleRentalDataSourceParameters>();
        for (JsonNode source : sources) {
            Optional<String> network = JsonUtils.asText(source, parameters.getSourceNetworkName());
            Optional<String> updaterUrl = JsonUtils.asText(source, parameters.getSourceUrlName());
            if (network.isEmpty() || updaterUrl.isEmpty()) {
                LOG.warn("Error reading json from {}. Are json tag names configured properly?", (Object)parameters.getUrl());
                continue;
            }
            String networkName = network.get();
            Optional<NetworkParameters> config = parameters.networkParameters(networkName);
            if (config.isPresent()) {
                NetworkParameters networkParams = config.get();
                dataSources.add(new GbfsVehicleRentalDataSourceParameters(updaterUrl.get(), parameters.getLanguage(), networkParams.allowKeepingAtDestination(), parameters.getHeaders(), networkName, networkParams.geofencingZones(), false, RentalPickupType.ALL));
                continue;
            }
            LOG.warn("Network not configured in OTP: {}", (Object)networkName);
        }
        return dataSources;
    }

    private List<GraphUpdater> fetchUpdaterInfoFromDirectoryAndCreateUpdaters(List<GbfsVehicleRentalDataSourceParameters> dataSources) {
        ArrayList<GraphUpdater> updaters = new ArrayList<GraphUpdater>();
        for (GbfsVehicleRentalDataSourceParameters it : dataSources) {
            updaters.add(this.fetchAndCreateUpdater(it));
        }
        LOG.info("{} updaters fetched", (Object)updaters.size());
        return updaters;
    }

    private VehicleRentalUpdater fetchAndCreateUpdater(GbfsVehicleRentalDataSourceParameters parameters) {
        LOG.info("Fetched updater info for {} at url {}", (Object)parameters.network(), (Object)parameters.url());
        VehicleRentalParameters vehicleRentalParameters = new VehicleRentalParameters("vehicle-rental-service-directory:" + parameters.network(), DEFAULT_FREQUENCY, parameters);
        VehicleRentalDataSource dataSource = VehicleRentalDataSourceFactory.create(vehicleRentalParameters.sourceParameters(), this.otpHttpClientFactory);
        return new VehicleRentalUpdater(vehicleRentalParameters, dataSource, this.vertexLinker, this.repository);
    }

    private static JsonNode listSources(VehicleRentalServiceDirectoryFetcherParameters parameters) {
        JsonNode node;
        URI url = parameters.getUrl();
        try {
            OtpHttpClient otpHttpClient = new OtpHttpClientFactory().create(LOG);
            node = otpHttpClient.getAndMapAsJsonNode(url, Map.of(), new ObjectMapper());
        }
        catch (OtpHttpClientException e) {
            LOG.warn("Error fetching list of vehicle rental endpoints from {}", (Object)url, (Object)e);
            return MissingNode.getInstance();
        }
        if (node == null) {
            LOG.warn("Error reading json from {}. Node is null!", (Object)url);
            return MissingNode.getInstance();
        }
        String sourcesName = parameters.getSourcesName();
        JsonNode sources = node.get(sourcesName);
        if (sources == null) {
            LOG.warn("Error reading json from {}. No JSON node for sources name '{}' found.", (Object)url, (Object)sourcesName);
            return MissingNode.getInstance();
        }
        return sources;
    }
}

