/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.sirifm;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.entur.siri21.util.SiriXml;
import org.opentripplanner.ext.vehicleparking.sirifm.SiriFmUpdaterParameters;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.spi.DataSource;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.vehicle_parking.AvailabiltyUpdate;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.CountingTypeEnumeration;
import uk.org.siri.siri21.FacilityConditionStructure;
import uk.org.siri.siri21.Siri;

public class SiriFmDataSource
implements DataSource<AvailabiltyUpdate> {
    private static final Logger LOG = LoggerFactory.getLogger(SiriFmDataSource.class);
    private final SiriFmUpdaterParameters params;
    private final OtpHttpClient httpClient;
    private final Map<String, String> headers;
    private List<AvailabiltyUpdate> updates = List.of();

    public SiriFmDataSource(SiriFmUpdaterParameters parameters) {
        this.params = parameters;
        this.headers = HttpHeaders.of().acceptApplicationXML().add(parameters.httpHeaders()).build().asMap();
        this.httpClient = new OtpHttpClientFactory().create(LOG);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("url", this.params.url().toString()).toString();
    }

    @Override
    public boolean update() {
        this.updates = this.httpClient.getAndMap(this.params.url(), this.headers, resp -> {
            Siri siri = SiriXml.parseXml((InputStream)resp);
            return Stream.ofNullable(siri.getServiceDelivery()).flatMap(sd -> sd.getFacilityMonitoringDeliveries().stream()).flatMap(d -> d.getFacilityConditions().stream()).filter(this::conformsToItalianProfile).map(this::mapToUpdate).toList();
        });
        return true;
    }

    private AvailabiltyUpdate mapToUpdate(FacilityConditionStructure c) {
        FeedScopedId id = new FeedScopedId(this.params.feedId(), c.getFacilityRef().getValue());
        int available = ((FacilityConditionStructure.MonitoredCounting)c.getMonitoredCountings().getFirst()).getCount().intValue();
        return new AvailabiltyUpdate(id, available);
    }

    private boolean conformsToItalianProfile(FacilityConditionStructure c) {
        return c.getFacilityRef() != null && c.getFacilityRef().getValue() != null && c.getMonitoredCountings().size() == 1 && ((FacilityConditionStructure.MonitoredCounting)c.getMonitoredCountings().getFirst()).getCountingType() == CountingTypeEnumeration.PRESENT_COUNT;
    }

    @Override
    public List<AvailabiltyUpdate> getUpdates() {
        return this.updates;
    }
}

