/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.liipi;

import com.fasterxml.jackson.databind.JsonNode;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiParkPatch;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiParkToVehicleParkingMapper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiipiParkUtilizationToPatchMapper {
    private static final Logger log = LoggerFactory.getLogger(LiipiParkUtilizationToPatchMapper.class);
    private final String feedId;

    public LiipiParkUtilizationToPatchMapper(String feedId) {
        this.feedId = feedId;
    }

    public LiipiParkPatch parseUtilization(JsonNode jsonNode) {
        FeedScopedId vehicleParkId = LiipiParkToVehicleParkingMapper.createIdForNode(jsonNode, "facilityId", this.feedId);
        try {
            String capacityType = jsonNode.path("capacityType").asText();
            Integer spacesAvailable = LiipiParkToVehicleParkingMapper.parseIntegerValue(jsonNode, "spacesAvailable");
            return new LiipiParkPatch(vehicleParkId, capacityType, spacesAvailable);
        }
        catch (Exception e) {
            log.warn("Error parsing park utilization {}", (Object)vehicleParkId, (Object)e);
            return null;
        }
    }
}

