/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.liipi;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiFacilitiesDownloader;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiHubToVehicleParkingGroupMapper;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiHubsDownloader;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiParkPatch;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiParkToVehicleParkingMapper;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiParkUpdaterParameters;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiParkUtilizationToPatchMapper;
import org.opentripplanner.framework.io.JsonDataListDownloader;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingGroup;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingSpaces;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.spi.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiipiParkUpdater
implements DataSource<VehicleParking> {
    private static final Logger LOG = LoggerFactory.getLogger(LiipiParkUpdater.class);
    private static final String JSON_PARSE_PATH = "results";
    private final LiipiFacilitiesDownloader facilitiesDownloader;
    private final int facilitiesFrequencySec;
    private final LiipiHubsDownloader hubsDownloader;
    private final JsonDataListDownloader utilizationsDownloader;
    private final LiipiParkToVehicleParkingMapper vehicleParkingMapper;
    private final LiipiHubToVehicleParkingGroupMapper vehicleParkingGroupMapper;
    private final LiipiParkUtilizationToPatchMapper parkPatchMapper;
    private long lastFacilitiesFetchTime;
    private List<VehicleParking> parks;
    private Map<FeedScopedId, VehicleParkingGroup> hubForPark;

    public LiipiParkUpdater(LiipiParkUpdaterParameters parameters, OpeningHoursCalendarService openingHoursCalendarService) {
        String feedId = parameters.feedId();
        this.vehicleParkingMapper = new LiipiParkToVehicleParkingMapper(feedId, openingHoursCalendarService, parameters.timeZone());
        this.vehicleParkingGroupMapper = new LiipiHubToVehicleParkingGroupMapper(feedId);
        this.parkPatchMapper = new LiipiParkUtilizationToPatchMapper(feedId);
        OtpHttpClientFactory otpHttpClientFactory = new OtpHttpClientFactory();
        this.facilitiesDownloader = new LiipiFacilitiesDownloader(parameters.facilitiesUrl(), JSON_PARSE_PATH, this.vehicleParkingMapper::parsePark, otpHttpClientFactory);
        this.hubsDownloader = new LiipiHubsDownloader(parameters.hubsUrl(), JSON_PARSE_PATH, this.vehicleParkingGroupMapper::parseHub, otpHttpClientFactory);
        this.utilizationsDownloader = new JsonDataListDownloader<LiipiParkPatch>(parameters.utilizationsUrl(), "", this.parkPatchMapper::parseUtilization, Map.of(), otpHttpClientFactory.create(LOG));
        this.facilitiesFrequencySec = parameters.facilitiesFrequencySec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        Map<FeedScopedId, VehicleParkingGroup> hubForPark;
        List<VehicleParking> parks = null;
        if (this.fetchFacilitiesAndHubsNow()) {
            hubForPark = this.hubsDownloader.downloadHubs();
            if (hubForPark != null && (parks = this.facilitiesDownloader.downloadFacilities(hubForPark)) != null) {
                this.lastFacilitiesFetchTime = System.currentTimeMillis();
            }
        } else {
            parks = this.parks;
            hubForPark = this.hubForPark;
        }
        if (parks != null) {
            List utilizations = this.utilizationsDownloader.download();
            if (utilizations != null) {
                Map<FeedScopedId, List<LiipiParkPatch>> patches = utilizations.stream().collect(Collectors.groupingBy(utilization -> utilization.getId()));
                parks.forEach(park -> {
                    List patchesForPark = (List)patches.get(park.getId());
                    if (patchesForPark != null) {
                        park.updateAvailability(LiipiParkUpdater.createVehicleAvailability(patchesForPark));
                    }
                });
            } else if (this.parks != null) {
                return false;
            }
            LiipiParkUpdater liipiParkUpdater = this;
            synchronized (liipiParkUpdater) {
                this.parks = parks;
                this.hubForPark = hubForPark;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<VehicleParking> getUpdates() {
        return this.parks;
    }

    private static VehicleParkingSpaces createVehicleAvailability(List<LiipiParkPatch> patches) {
        VehicleParkingSpaces.VehicleParkingSpacesBuilder availabilityBuilder = VehicleParkingSpaces.builder();
        boolean hasHandledSpaces = false;
        for (LiipiParkPatch patch : patches) {
            String type = patch.getCapacityType();
            if (type == null) continue;
            Integer spaces = patch.getSpacesAvailable();
            switch (type) {
                case "CAR": {
                    availabilityBuilder.carSpaces(spaces);
                    hasHandledSpaces = true;
                    break;
                }
                case "BICYCLE": {
                    availabilityBuilder.bicycleSpaces(spaces);
                    hasHandledSpaces = true;
                    break;
                }
                case "DISABLED": {
                    availabilityBuilder.wheelchairAccessibleCarSpaces(spaces);
                    hasHandledSpaces = true;
                }
            }
        }
        return hasHandledSpaces ? availabilityBuilder.build() : null;
    }

    private boolean fetchFacilitiesAndHubsNow() {
        if (this.parks == null) {
            return true;
        }
        if (this.facilitiesFrequencySec <= 0) {
            return false;
        }
        return System.currentTimeMillis() > this.lastFacilitiesFetchTime + (long)(this.facilitiesFrequencySec * 1000);
    }
}

