/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.liipi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingGroup;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiipiHubsDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(LiipiHubsDownloader.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final String jsonParsePath;
    private final Function<JsonNode, Map<FeedScopedId, VehicleParkingGroup>> hubsParser;
    private final String url;
    private final OtpHttpClient otpHttpClient;

    public LiipiHubsDownloader(String url, String jsonParsePath, Function<JsonNode, Map<FeedScopedId, VehicleParkingGroup>> hubsParser, OtpHttpClientFactory otpHttpClientFactory) {
        this.url = url;
        this.jsonParsePath = jsonParsePath;
        this.hubsParser = hubsParser;
        this.otpHttpClient = otpHttpClientFactory.create(LOG);
    }

    public Map<FeedScopedId, VehicleParkingGroup> downloadHubs() {
        if (this.url == null) {
            LOG.warn("Cannot download updates, because url is null!");
            return null;
        }
        try {
            return this.otpHttpClient.getAndMap(URI.create(this.url), Map.of(), is -> {
                try {
                    return this.parseJSON(is);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Error parsing hubs from {}", (Object)this.url, (Object)e);
                }
                catch (JsonProcessingException e) {
                    LOG.warn("Error parsing hubs from {} (bad JSON of some sort)", (Object)this.url, (Object)e);
                }
                catch (IOException e) {
                    LOG.warn("Error reading hubs from {}", (Object)this.url, (Object)e);
                }
                return null;
            });
        }
        catch (OtpHttpClientException e) {
            LOG.warn("Failed to get data from url {}", (Object)this.url);
            return null;
        }
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner scanner = new Scanner(is).useDelimiter("\\A");){
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private Map<FeedScopedId, VehicleParkingGroup> parseJSON(InputStream dataStream) throws IllegalArgumentException, IOException {
        HashMap<FeedScopedId, VehicleParkingGroup> out = new HashMap<FeedScopedId, VehicleParkingGroup>();
        String hubsString = LiipiHubsDownloader.convertStreamToString(dataStream);
        JsonNode rootNode = mapper.readTree(hubsString);
        if (!this.jsonParsePath.isEmpty()) {
            String[] parseElement;
            String delimiter = "/";
            for (String s : parseElement = this.jsonParsePath.split(delimiter)) {
                rootNode = rootNode.path(s);
            }
            if (rootNode.isMissingNode()) {
                throw new IllegalArgumentException("Could not find jSON elements " + this.jsonParsePath);
            }
        }
        for (JsonNode node : rootNode) {
            Map<FeedScopedId, VehicleParkingGroup> parsedElement;
            if (node == null || (parsedElement = this.hubsParser.apply(node)) == null) continue;
            out.putAll(parsedElement);
        }
        return out;
    }
}

