/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.liipi;

import com.bedatadriven.jackson.datatype.jts.parsers.GenericGeometryParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.ext.vehicleparking.liipi.LiipiParkToVehicleParkingMapper;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingGroup;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiipiHubToVehicleParkingGroupMapper {
    private static final Logger log = LoggerFactory.getLogger(LiipiHubToVehicleParkingGroupMapper.class);
    private static final GenericGeometryParser GEOMETRY_PARSER = new GenericGeometryParser(GeometryUtils.getGeometryFactory());
    private final String feedId;

    public LiipiHubToVehicleParkingGroupMapper(String feedId) {
        this.feedId = feedId;
    }

    public Map<FeedScopedId, VehicleParkingGroup> parseHub(JsonNode jsonNode) {
        FeedScopedId hubId = LiipiParkToVehicleParkingMapper.createIdForNode(jsonNode, "id", this.feedId);
        try {
            HashMap<String, String> translations = new HashMap<String, String>();
            JsonNode nameNode = jsonNode.path("name");
            nameNode.fieldNames().forEachRemaining(lang -> {
                String name = nameNode.path(lang).asText();
                if (!name.isEmpty()) {
                    translations.put((String)lang, nameNode.path(lang).asText());
                }
            });
            I18NString name = translations.isEmpty() ? new NonLocalizedString(hubId.getId()) : TranslatedString.getI18NString(translations, true, false);
            Geometry geometry = GEOMETRY_PARSER.geometryFromJson(jsonNode.path("location"));
            VehicleParkingGroup vehicleParkingGroup = VehicleParkingGroup.of(hubId).withName(name).withCoordinate(new WgsCoordinate(geometry.getCentroid())).build();
            List<FeedScopedId> vehicleParkingIds = this.getVehicleParkingIds((ArrayNode)jsonNode.get("facilityIds"), hubId);
            if (vehicleParkingIds == null) {
                return null;
            }
            HashMap<FeedScopedId, VehicleParkingGroup> hubForPark = new HashMap<FeedScopedId, VehicleParkingGroup>();
            vehicleParkingIds.forEach(vehicleParkingId -> hubForPark.put((FeedScopedId)vehicleParkingId, vehicleParkingGroup));
            return hubForPark;
        }
        catch (Exception e) {
            log.warn("Error parsing hub {}", (Object)hubId, (Object)e);
            return null;
        }
    }

    public List<FeedScopedId> getVehicleParkingIds(ArrayNode facilityIdsNode, FeedScopedId hubId) {
        if (facilityIdsNode == null || !facilityIdsNode.isArray() || facilityIdsNode.isEmpty()) {
            log.warn("Hub {} contained no facilities", (Object)hubId);
            return null;
        }
        ArrayList<FeedScopedId> vehicleParkingIds = new ArrayList<FeedScopedId>();
        for (JsonNode jsonNode : facilityIdsNode) {
            vehicleParkingIds.add(new FeedScopedId(this.feedId, jsonNode.asText()));
        }
        return vehicleParkingIds;
    }
}

