/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.liipi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.BiFunction;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingGroup;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiipiFacilitiesDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(LiipiFacilitiesDownloader.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final String jsonParsePath;
    private final BiFunction<JsonNode, Map<FeedScopedId, VehicleParkingGroup>, VehicleParking> facilitiesParser;
    private final String url;
    private final OtpHttpClient otpHttpClient;

    public LiipiFacilitiesDownloader(String url, String jsonParsePath, BiFunction<JsonNode, Map<FeedScopedId, VehicleParkingGroup>, VehicleParking> facilitiesParser, OtpHttpClientFactory otpHttpClientFactory) {
        this.url = url;
        this.jsonParsePath = jsonParsePath;
        this.facilitiesParser = facilitiesParser;
        this.otpHttpClient = otpHttpClientFactory.create(LOG);
    }

    public List<VehicleParking> downloadFacilities(Map<FeedScopedId, VehicleParkingGroup> hubForPark) {
        if (this.url == null) {
            LOG.warn("Cannot download updates, because url is null!");
            return null;
        }
        try {
            return this.otpHttpClient.getAndMap(URI.create(this.url), Map.of(), is -> {
                try {
                    return this.parseJSON(is, hubForPark);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Error parsing facilities from {}", (Object)this.url, (Object)e);
                }
                catch (JsonProcessingException e) {
                    LOG.warn("Error parsing facilities from {} (bad JSON of some sort)", (Object)this.url, (Object)e);
                }
                catch (IOException e) {
                    LOG.warn("Error reading facilities from {}", (Object)this.url, (Object)e);
                }
                return null;
            });
        }
        catch (OtpHttpClientException e) {
            LOG.warn("Failed to get data from url {}", (Object)this.url);
            return null;
        }
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner scanner = new Scanner(is).useDelimiter("\\A");){
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private List<VehicleParking> parseJSON(InputStream dataStream, Map<FeedScopedId, VehicleParkingGroup> hubForPark) throws IllegalArgumentException, IOException {
        ArrayList<VehicleParking> out = new ArrayList<VehicleParking>();
        String facilitiesString = LiipiFacilitiesDownloader.convertStreamToString(dataStream);
        JsonNode rootNode = mapper.readTree(facilitiesString);
        if (!this.jsonParsePath.isEmpty()) {
            String[] parseElement;
            String delimiter = "/";
            for (String s : parseElement = this.jsonParsePath.split(delimiter)) {
                rootNode = rootNode.path(s);
            }
            if (rootNode.isMissingNode()) {
                throw new IllegalArgumentException("Could not find jSON elements " + this.jsonParsePath);
            }
        }
        for (JsonNode node : rootNode) {
            VehicleParking parsedElement;
            if (node == null || (parsedElement = this.facilitiesParser.apply(node, hubForPark)) == null) continue;
            out.add(parsedElement);
        }
        return out;
    }
}

