/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.bikely;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.ext.vehicleparking.bikely.BikelyUpdaterParameters;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.LocalizedString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.framework.json.ObjectMappers;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingSpaces;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingState;
import org.opentripplanner.transit.model.basic.LocalizedMoney;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.spi.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BikelyUpdater
implements DataSource<VehicleParking> {
    private static final Logger LOG = LoggerFactory.getLogger(BikelyUpdater.class);
    private static final String JSON_PARSE_PATH = "result";
    private static final Currency NOK = Currency.getInstance("NOK");
    private static final ObjectMapper OBJECT_MAPPER = ObjectMappers.ignoringExtraFields();
    private static final ObjectNode POST_PARAMS = OBJECT_MAPPER.createObjectNode().put("groupPins", true).put("lonMin", 0).put("lonMax", 0).put("latMin", 0).put("latMax", 0);
    private final OtpHttpClient httpClient = new OtpHttpClientFactory().create(LOG);
    private final BikelyUpdaterParameters parameters;
    private List<VehicleParking> lots;

    public BikelyUpdater(BikelyUpdaterParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean update() {
        this.lots = this.httpClient.postJsonAndMap(this.parameters.url(), (JsonNode)POST_PARAMS, Duration.ofSeconds(30L), this.parameters.httpHeaders().asMap(), is -> {
            try {
                ArrayList lots = new ArrayList();
                OBJECT_MAPPER.readTree(is).path(JSON_PARSE_PATH).forEach(node -> lots.add(this.parseElement((JsonNode)node)));
                return lots.stream().filter(Objects::nonNull).toList();
            }
            catch (Exception e) {
                LOG.error("Could not get Bikely updates", (Throwable)e);
                return List.of();
            }
        });
        return true;
    }

    @Override
    public List<VehicleParking> getUpdates() {
        return List.copyOf(this.lots);
    }

    @Nullable
    private VehicleParking parseElement(JsonNode jsonNode) {
        if (jsonNode.path("hasStandardParking").asBoolean()) {
            FeedScopedId vehicleParkId = new FeedScopedId(this.parameters.feedId(), jsonNode.get("id").asText());
            double lat = jsonNode.get("latitude").asDouble();
            double lng = jsonNode.get("longitude").asDouble();
            WgsCoordinate coord = new WgsCoordinate(lat, lng);
            NonLocalizedString name = new NonLocalizedString(jsonNode.path("name").asText());
            int totalSpots = jsonNode.get("totalStandardSpots").asInt();
            int freeSpots = jsonNode.get("availableStandardSpots").asInt();
            boolean isUnderMaintenance = jsonNode.get("isInMaintenance").asBoolean();
            LocalizedString note = BikelyUpdater.toNote(jsonNode);
            VehicleParking.VehicleParkingEntranceCreator entrance = builder -> builder.entranceId(new FeedScopedId(this.parameters.feedId(), vehicleParkId.getId() + "/entrance")).name(name).coordinate(coord).walkAccessible(true).carAccessible(false);
            return VehicleParking.builder().id(vehicleParkId).name(name).bicyclePlaces(true).capacity(VehicleParkingSpaces.builder().bicycleSpaces(totalSpots).build()).availability(VehicleParkingSpaces.builder().bicycleSpaces(freeSpots).build()).state(BikelyUpdater.toState(isUnderMaintenance)).coordinate(coord).entrance(entrance).note(note).build();
        }
        return null;
    }

    private static LocalizedString toNote(JsonNode price) {
        float startPriceAmount = price.get("startPriceAmount").floatValue();
        float mainPriceAmount = price.get("mainPriceAmount").floatValue();
        int startPriceDurationHours = price.get("startPriceDuration").asInt();
        int mainPriceDurationHours = price.get("mainPriceDuration").asInt();
        if (startPriceAmount == 0.0f && mainPriceAmount == 0.0f) {
            return new LocalizedString("price.free");
        }
        return new LocalizedString("price.startMain", NonLocalizedString.ofNumber(startPriceDurationHours), new LocalizedMoney(Money.ofFractionalAmount(NOK, startPriceAmount)), new LocalizedMoney(Money.ofFractionalAmount(NOK, mainPriceAmount)), NonLocalizedString.ofNumber(mainPriceDurationHours));
    }

    private static VehicleParkingState toState(boolean isUnderMaintenance) {
        if (isUnderMaintenance) {
            return VehicleParkingState.TEMPORARILY_CLOSED;
        }
        return VehicleParkingState.OPERATIONAL;
    }
}

