/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.bikeep;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.List;
import org.opentripplanner.ext.vehicleparking.bikeep.BikeepUpdaterParameters;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.json.ObjectMappers;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingSpaces;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingState;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.spi.GenericJsonDataSource;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class BikeepUpdater
extends GenericJsonDataSource<VehicleParking> {
    private static final String JSON_PARSE_PATH = "features";
    private static final ObjectReader STRING_LIST_READER = ObjectMappers.ignoringExtraFields().readerForListOf(String.class);
    private final BikeepUpdaterParameters params;

    public BikeepUpdater(BikeepUpdaterParameters parameters) {
        super(parameters.url().toString(), JSON_PARSE_PATH, parameters.httpHeaders());
        this.params = parameters;
    }

    @Override
    protected VehicleParking parseElement(JsonNode jsonNode) {
        try {
            JsonNode coords = jsonNode.path("geometry").path("coordinates");
            WgsCoordinate coordinate = new WgsCoordinate(coords.get(1).asDouble(), coords.get(0).asDouble());
            JsonNode props = jsonNode.path("properties");
            FeedScopedId vehicleParkId = new FeedScopedId(this.params.feedId(), props.path("code").asText());
            NonLocalizedString name = new NonLocalizedString(props.path("label").asText());
            JsonNode parking = props.path("parking");
            List tags = (List)STRING_LIST_READER.readValue(props.path("tags"));
            VehicleParkingSpaces availability = VehicleParkingSpaces.builder().bicycleSpaces(parking.get("available").asInt()).build();
            VehicleParkingSpaces capacity = VehicleParkingSpaces.builder().bicycleSpaces(parking.get("total").asInt()).build();
            VehicleParking.VehicleParkingEntranceCreator entrance = builder -> builder.entranceId(new FeedScopedId(this.params.feedId(), vehicleParkId.getId() + "/entrance")).coordinate(coordinate).walkAccessible(true).carAccessible(true);
            return VehicleParking.builder().id(vehicleParkId).name(name).state(VehicleParkingState.OPERATIONAL).coordinate(coordinate).bicyclePlaces(true).availability(availability).tags(tags).capacity(capacity).entrance(entrance).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("feedId", this.params.feedId()).addStr("url", this.params.url().toString()).toString();
    }
}

