/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.vehicleparkings;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.apis.support.mapping.PropertyMapper;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.DigitransitVehicleParkingGroupPropertyMapper;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.VehicleParkingAndGroup;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.service.vehicleparking.VehicleParkingService;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingGroup;

public class VehicleParkingGroupsLayerBuilder
extends LayerBuilder<VehicleParkingAndGroup> {
    static Map<MapperType, Function<Locale, PropertyMapper<VehicleParkingAndGroup>>> mappers = Map.of(MapperType.Digitransit, DigitransitVehicleParkingGroupPropertyMapper::create);
    private final VehicleParkingService service;

    public VehicleParkingGroupsLayerBuilder(VehicleParkingService service, LayerParameters<VectorTilesResource.LayerType> layerParameters, Locale locale) {
        super(mappers.get((Object)MapperType.valueOf(layerParameters.mapper())).apply(locale), layerParameters.name(), layerParameters.expansionFactor());
        this.service = service;
    }

    @Override
    protected List<Geometry> getGeometries(Envelope query) {
        return this.service.listVehicleParkingGroups().asMap().entrySet().stream().map(vehicleParkingGroupEntry -> {
            VehicleParkingGroup group = (VehicleParkingGroup)vehicleParkingGroupEntry.getKey();
            Coordinate coordinate = group.coordinate().asJtsCoordinate();
            Point point = GeometryUtils.getGeometryFactory().createPoint(coordinate);
            Collection parking = (Collection)vehicleParkingGroupEntry.getValue();
            VehicleParkingAndGroup parkingAndGroup = new VehicleParkingAndGroup(group, parking);
            point.setUserData((Object)parkingAndGroup);
            return point;
        }).toList();
    }

    static enum MapperType {
        Digitransit;

    }
}

