/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.vehicleparkings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.opentripplanner.apis.support.mapping.PropertyMapper;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.VehicleParkingAndGroup;
import org.opentripplanner.framework.i18n.I18NStringMapper;
import org.opentripplanner.framework.json.ObjectMappers;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingGroup;

public class DigitransitVehicleParkingGroupPropertyMapper
extends PropertyMapper<VehicleParkingAndGroup> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMappers.ignoringExtraFields();
    private final I18NStringMapper i18NStringMapper;

    public DigitransitVehicleParkingGroupPropertyMapper(Locale locale) {
        this.i18NStringMapper = new I18NStringMapper(locale);
    }

    public static DigitransitVehicleParkingGroupPropertyMapper create(Locale locale) {
        return new DigitransitVehicleParkingGroupPropertyMapper(locale);
    }

    @Override
    protected Collection<KeyValue> map(VehicleParkingAndGroup parkingAndGroup) {
        try {
            VehicleParkingGroup group = parkingAndGroup.vehicleParkingGroup();
            List<ObjectNode> lots = parkingAndGroup.vehicleParking().stream().map((? super T vehicleParkingPlace) -> {
                ObjectNode parkingObject = OBJECT_MAPPER.createObjectNode();
                parkingObject.put("carPlaces", vehicleParkingPlace.hasCarPlaces());
                parkingObject.put("bicyclePlaces", vehicleParkingPlace.hasBicyclePlaces());
                parkingObject.put("id", vehicleParkingPlace.getId().toString());
                parkingObject.put("name", this.i18NStringMapper.mapToApi(vehicleParkingPlace.getName()));
                return parkingObject;
            }).toList();
            String string = OBJECT_MAPPER.writeValueAsString(lots);
            return List.of(new KeyValue("id", group.id().toString()), new KeyValue("name", this.i18NStringMapper.mapToApi(group.name())), new KeyValue("vehicleParking", string));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

