/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.stops;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.apis.support.mapping.PropertyMapper;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.ext.vectortiles.layers.LayerFilters;
import org.opentripplanner.ext.vectortiles.layers.stops.DigitransitRealtimeStopPropertyMapper;
import org.opentripplanner.ext.vectortiles.layers.stops.DigitransitStopPropertyMapper;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.TransitService;

public class StopsLayerBuilder
extends LayerBuilder<RegularStop> {
    private final TransitService transitService;
    private final Predicate<RegularStop> filter;

    public StopsLayerBuilder(TransitService transitService, LayerParameters<VectorTilesResource.LayerType> layerParameters, Locale locale) {
        super((PropertyMapper)Map.ofEntries(Map.entry(MapperType.Digitransit, new DigitransitStopPropertyMapper(transitService, locale)), Map.entry(MapperType.DigitransitRealtime, new DigitransitRealtimeStopPropertyMapper(transitService, locale))).get((Object)MapperType.valueOf(layerParameters.mapper())), layerParameters.name(), layerParameters.expansionFactor());
        this.transitService = transitService;
        this.filter = LayerFilters.forType(layerParameters.filterType(), transitService);
    }

    @Override
    protected List<Geometry> getGeometries(Envelope query) {
        return this.transitService.findRegularStopsByBoundingBox(query).stream().filter(this.filter).map(stop -> {
            Point point = stop.getGeometry();
            point.setUserData(stop);
            return point;
        }).toList();
    }

    static enum MapperType {
        Digitransit,
        DigitransitRealtime;

    }
}

