/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.stops;

import java.time.Instant;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.opentripplanner.apis.support.mapping.PropertyMapper;
import org.opentripplanner.ext.vectortiles.layers.stops.DigitransitStopPropertyMapper;
import org.opentripplanner.framework.i18n.I18NStringMapper;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.collection.ListUtils;

public class DigitransitRealtimeStopPropertyMapper
extends PropertyMapper<RegularStop> {
    private final TransitService transitService;
    private final I18NStringMapper i18NStringMapper;

    public DigitransitRealtimeStopPropertyMapper(TransitService transitService, Locale locale) {
        this.transitService = transitService;
        this.i18NStringMapper = new I18NStringMapper(locale);
    }

    @Override
    protected Collection<KeyValue> map(RegularStop stop) {
        Instant currentTime = Instant.now();
        boolean noServiceAlert = this.transitService.getTransitAlertService().getStopAlerts(stop.getId()).stream().anyMatch(alert -> alert.noServiceAt(currentTime));
        LocalDate serviceDate = LocalDate.now(this.transitService.getTimeZone());
        boolean stopTimesExist = this.transitService.findStopTimesInPattern(stop, serviceDate, ArrivalDeparture.BOTH, true).stream().anyMatch(stopTime -> stopTime.times.size() > 0);
        boolean inService = this.transitService.hasScheduledServicesAfter(LocalDate.now(), stop);
        Collection<KeyValue> sharedKeyValues = DigitransitStopPropertyMapper.getBaseKeyValues(stop, this.i18NStringMapper, this.transitService);
        return ListUtils.combine((Collection[])new Collection[]{sharedKeyValues, List.of(new KeyValue("closedByServiceAlert", noServiceAlert), new KeyValue("servicesRunningOnServiceDate", stopTimesExist), new KeyValue("servicesRunningInFuture", inService))});
    }
}

