/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.opentripplanner.apis.gtfs.model.LocalDateRange;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.PatternByServiceDatesFilter;
import org.opentripplanner.transit.service.TransitService;

public class LayerFilters {
    public static final Predicate<RegularStop> NO_FILTER = x -> true;

    public static Predicate<RegularStop> buildCurrentServiceWeekPredicate(Function<RegularStop, Collection<TripPattern>> getPatternsForStop, Function<Trip, Collection<LocalDate>> getServiceDatesForTrip, Supplier<LocalDate> nowSupplier) {
        LocalDate serviceDate = nowSupplier.get();
        LocalDate lastSunday = serviceDate.with(TemporalAdjusters.previousOrSame(DayOfWeek.SUNDAY));
        LocalDate nextSundayPlusOne = serviceDate.with(TemporalAdjusters.next(DayOfWeek.SUNDAY)).plusDays(1L);
        PatternByServiceDatesFilter filter = new PatternByServiceDatesFilter(new LocalDateRange(lastSunday, nextSundayPlusOne), route -> List.of(), getServiceDatesForTrip);
        return regularStop -> {
            Collection patterns = (Collection)getPatternsForStop.apply((RegularStop)regularStop);
            Collection<TripPattern> patternsInCurrentWeek = filter.filterPatterns(patterns);
            return !patternsInCurrentWeek.isEmpty();
        };
    }

    public static Predicate<RegularStop> forType(FilterType type, TransitService transitService) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NO_FILTER;
            case 1 -> LayerFilters.buildCurrentServiceWeekPredicate(transitService::findPatterns, trip -> transitService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId()), () -> LocalDate.now(transitService.getTimeZone()));
        };
    }

    public static enum FilterType {
        NONE,
        SUNDAY_TO_SUNDAY_SERVICE_WEEK;

    }
}

