/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.glassfish.grizzly.http.server.Request;
import org.opentripplanner.apis.support.TileJson;
import org.opentripplanner.ext.vectortiles.layers.areastops.AreaStopsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.stations.StationsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.stops.StopsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.VehicleParkingGroupsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.VehicleParkingsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehiclerental.VehicleRentalPlacesLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehiclerental.VehicleRentalStationsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehiclerental.VehicleRentalVehiclesLayerBuilder;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.inspector.vector.VectorTileResponseFactory;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.routerconfig.VectorTileConfig;

@Path(value="/routers/{ignoreRouterId}/vectorTiles")
public class VectorTilesResource {
    private final OtpServerRequestContext serverContext;
    private final String ignoreRouterId;
    private final Locale locale;

    public VectorTilesResource(@Context OtpServerRequestContext serverContext, @Context Request grizzlyRequest, @Deprecated @PathParam(value="ignoreRouterId") String ignoreRouterId) {
        this.locale = grizzlyRequest.getLocale();
        this.serverContext = serverContext;
        this.ignoreRouterId = ignoreRouterId;
    }

    @GET
    @Path(value="/{layers}/{z}/{x}/{y}.pbf")
    @Produces(value={"application/x-protobuf"})
    public Response tileGet(@PathParam(value="x") int x, @PathParam(value="y") int y, @PathParam(value="z") int z, @PathParam(value="layers") String requestedLayers) {
        return VectorTileResponseFactory.create(x, y, z, this.locale, Arrays.asList(requestedLayers.split(",")), this.serverContext.vectorTileConfig().layers(), VectorTilesResource::createLayerBuilder, this.serverContext);
    }

    @GET
    @Path(value="/{layers}/tilejson.json")
    @Produces(value={"application/json"})
    public TileJson getTileJson(@Context UriInfo uri, @Context HttpHeaders headers, @PathParam(value="layers") String requestedLayers) {
        WorldEnvelope envelope = this.serverContext.worldEnvelopeService().envelope().orElseThrow();
        List<String> rLayers = Arrays.asList(requestedLayers.split(","));
        VectorTileConfig config = this.serverContext.vectorTileConfig();
        String url = config.basePath().map(overrideBasePath -> TileJson.urlFromOverriddenBasePath(uri, headers, overrideBasePath, rLayers)).orElseGet(() -> TileJson.urlWithDefaultPath(uri, headers, rLayers, this.ignoreRouterId, "vectorTiles"));
        int minZoom = config.minZoom(Set.copyOf(rLayers));
        int maxZoom = config.maxZoom(Set.copyOf(rLayers));
        return config.attribution().map(attr -> new TileJson(url, envelope, (String)attr, minZoom, maxZoom)).orElseGet(() -> {
            List<FeedInfo> feedInfos = this.getFeedInfos();
            return new TileJson(url, envelope, feedInfos, minZoom, maxZoom);
        });
    }

    private List<FeedInfo> getFeedInfos() {
        return this.serverContext.transitService().listFeedIds().stream().map(this.serverContext.transitService()::getFeedInfo).filter(Predicate.not(Objects::isNull)).toList();
    }

    private static LayerBuilder<?> createLayerBuilder(LayerParameters<LayerType> layerParameters, Locale locale, OtpServerRequestContext context) {
        return switch (layerParameters.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new StopsLayerBuilder(context.transitService(), layerParameters, locale);
            case 1 -> new StationsLayerBuilder(context.transitService(), layerParameters, locale);
            case 2 -> new AreaStopsLayerBuilder(context.transitService(), layerParameters, locale);
            case 3 -> new VehicleRentalPlacesLayerBuilder(context.vehicleRentalService(), layerParameters, locale);
            case 5 -> new VehicleRentalStationsLayerBuilder(context.vehicleRentalService(), layerParameters, locale);
            case 4 -> new VehicleRentalVehiclesLayerBuilder(context.vehicleRentalService(), layerParameters);
            case 6 -> new VehicleParkingsLayerBuilder(context.vehicleParkingService(), layerParameters, locale);
            case 7 -> new VehicleParkingGroupsLayerBuilder(context.vehicleParkingService(), layerParameters, locale);
        };
    }

    public static enum LayerType {
        Stop,
        Station,
        AreaStop,
        VehicleRental,
        VehicleRentalVehicle,
        VehicleRentalStation,
        VehicleParking,
        VehicleParkingGroup;

    }

    public static interface LayersParameters<T extends Enum<T>> {
        public List<LayerParameters<T>> layers();
    }
}

