/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.trias.trias;

import de.vdv.ojp20.OJP;
import de.vdv.ojp20.OJPStopEventRequestStructure;
import de.vdv.ojp20.siri.AbstractFunctionalServiceRequestStructure;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.opentripplanner.api.model.transit.DefaultFeedIdMapper;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.api.model.transit.HideFeedIdMapper;
import org.opentripplanner.ext.trias.mapping.ErrorMapper;
import org.opentripplanner.ext.trias.parameters.TriasApiParameters;
import org.opentripplanner.ext.trias.service.OjpService;
import org.opentripplanner.ext.trias.service.OjpServiceMapper;
import org.opentripplanner.ext.trias.trias.OjpToTriasTransformer;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.framework.EntityNotFoundException;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/trias/v1")
public class TriasResource {
    private static final Logger LOG = LoggerFactory.getLogger(TriasResource.class);
    private static final Set<String> ALLOWED_CLASSPATH_RESOURCES = Set.of("stop-event-coordinates.xml", "stop-event-stop-point.xml");
    private final OjpServiceMapper ojpService;

    public TriasResource(@Context OtpServerRequestContext context) {
        TransitService transitService = context.transitService();
        ZoneId zoneId = context.triasApiParameters().timeZone().orElse(transitService.getTimeZone());
        OjpService vdvService = new OjpService(context.transitService(), context.graphFinder());
        FeedScopedIdMapper idMapper = this.idMapper(context.triasApiParameters());
        this.ojpService = new OjpServiceMapper(vdvService, idMapper, zoneId);
    }

    private FeedScopedIdMapper idMapper(TriasApiParameters triasApiConfig) {
        if (triasApiConfig.hideFeedId()) {
            return new HideFeedIdMapper(triasApiConfig.hardcodedInputFeedId());
        }
        return new DefaultFeedIdMapper();
    }

    @POST
    @Produces(value={"application/xml"})
    public Response index(String triasInput) {
        try {
            OJP ojp = OjpToTriasTransformer.triasToOjp(triasInput);
            AbstractFunctionalServiceRequestStructure request = TriasResource.findRequest(ojp);
            if (request instanceof OJPStopEventRequestStructure) {
                OJPStopEventRequestStructure ser = (OJPStopEventRequestStructure)request;
                OJP ojpResponse = this.ojpService.handleStopEventRequest(ser);
                StreamingOutput stream = TriasResource.ojpToTrias(ojpResponse);
                return Response.ok((Object)stream).build();
            }
            return TriasResource.error("Request type '%s' is not supported".formatted(request.getClass().getSimpleName()));
        }
        catch (RoutingValidationException | EntityNotFoundException e) {
            return TriasResource.error(e.getMessage());
        }
        catch (JAXBException | TransformerException e) {
            LOG.error("Error reading TRIAS request", e);
            return TriasResource.error("Could not read TRIAS request.");
        }
        catch (Exception e) {
            LOG.error("Error processing TRIAS request", (Throwable)e);
            return TriasResource.error(e.getMessage());
        }
    }

    private static AbstractFunctionalServiceRequestStructure findRequest(OJP ojp) {
        return (AbstractFunctionalServiceRequestStructure)((JAXBElement)Optional.ofNullable(ojp.getOJPRequest()).map(s -> s.getServiceRequest()).stream().flatMap(s -> s.getAbstractFunctionalServiceRequest().stream()).findFirst().orElseThrow(() -> new IllegalArgumentException("No request found in TRIAS XML body."))).getValue();
    }

    private static Response error(String value) {
        StreamingOutput trias = TriasResource.ojpToTrias(ErrorMapper.error(value, ZonedDateTime.now()));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)trias).build();
    }

    private static StreamingOutput ojpToTrias(OJP ojpOutput) {
        return os -> {
            OutputStreamWriter writer = new OutputStreamWriter(os);
            OjpToTriasTransformer.ojpToTrias(ojpOutput, writer);
            ((Writer)writer).flush();
        };
    }

    @GET
    @Path(value="/explorer")
    @Produces(value={"text/html"})
    public Response explorer() throws IOException {
        return TriasResource.classpathResource("explorer.html");
    }

    @GET
    @Path(value="/static/config.json")
    @Produces(value={"application/json"})
    public Response configJson() throws IOException {
        return TriasResource.classpathResource("config.json");
    }

    @GET
    @Path(value="/static/api_templates.json")
    @Produces(value={"application/json"})
    public Response templatesJson() throws IOException {
        return TriasResource.classpathResource("api_templates.json");
    }

    @GET
    @Path(value="/static/{fileName}")
    @Produces(value={"application/xml"})
    public Response stopEventXml(@PathParam(value="fileName") String fileName) throws IOException {
        if (ALLOWED_CLASSPATH_RESOURCES.contains(fileName)) {
            return TriasResource.classpathResource(fileName);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private static Response classpathResource(String name) throws IOException {
        String resource = "explorer/" + name;
        InputStream res = Objects.requireNonNull(TriasResource.class.getResource(resource), "%s not found".formatted(resource)).openStream();
        return Response.ok((Object)res).build();
    }
}

