/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.trias.trias;

import de.vdv.ojp20.OJP;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

class OjpToTriasTransformer {
    private static final Templates OJP_TO_TRIAS_TEMPLATE = OjpToTriasTransformer.loadTemplate("trias_to_ojp2.0_response.xslt");
    private static final Templates TRIAS_TO_OJP_TEMPLATE = OjpToTriasTransformer.loadTemplate("trias_to_ojp2.0_request.xslt");
    private static final JAXBContext CONTEXT = OjpToTriasTransformer.jaxbContext();

    OjpToTriasTransformer() {
    }

    static String ojpToTrias(OJP ojp) {
        StringWriter writer = new StringWriter();
        OjpToTriasTransformer.ojpToTrias(ojp, writer);
        return writer.toString();
    }

    static void ojpToTrias(OJP ojp, Writer writer) {
        try {
            Marshaller marshaller = CONTEXT.createMarshaller();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            marshaller.marshal((Object)ojp, (OutputStream)outputStream);
            StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(outputStream.toByteArray()));
            OjpToTriasTransformer.ojpToTrias(writer, xmlSource);
        }
        catch (JAXBException | IOException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    static OJP triasToOjp(String trias) throws JAXBException, TransformerException {
        StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(trias.getBytes(StandardCharsets.UTF_8)));
        Transformer transformer = TRIAS_TO_OJP_TEMPLATE.newTransformer();
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        transformer.transform(xmlSource, new StreamResult(writer));
        String transformedXml = writer.toString(StandardCharsets.UTF_8);
        Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
        return (OJP)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(transformedXml.getBytes(StandardCharsets.UTF_8)));
    }

    static void ojpToTrias(Writer writer, StreamSource xmlSource) throws IOException, TransformerException {
        Transformer transformer = OJP_TO_TRIAS_TEMPLATE.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(xmlSource, new StreamResult(writer));
    }

    static Templates loadTemplate(String name) {
        try {
            InputStream xslt = OjpToTriasTransformer.class.getResource(name).openStream();
            StreamSource xsltSource = new StreamSource(xslt);
            TransformerFactory factory = TransformerFactory.newInstance();
            return factory.newTemplates(xsltSource);
        }
        catch (IOException | TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static JAXBContext jaxbContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{OJP.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

