/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.trias.service;

import de.vdv.ojp20.LineDirectionFilterStructure;
import de.vdv.ojp20.ModeFilterStructure;
import de.vdv.ojp20.OJP;
import de.vdv.ojp20.OJPStopEventRequestStructure;
import de.vdv.ojp20.OperatorFilterStructure;
import de.vdv.ojp20.PersonalModesEnumeration;
import de.vdv.ojp20.PlaceContextStructure;
import de.vdv.ojp20.PlaceRefStructure;
import de.vdv.ojp20.StopEventParamStructure;
import de.vdv.ojp20.StopEventTypeEnumeration;
import de.vdv.ojp20.UseRealtimeDataEnumeration;
import de.vdv.ojp20.siri.StopPointRefStructure;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.ext.trias.mapping.PtModeMapper;
import org.opentripplanner.ext.trias.mapping.StopEventResponseMapper;
import org.opentripplanner.ext.trias.service.CallAtStop;
import org.opentripplanner.ext.trias.service.OjpService;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.ArrivalDeparture;

public class OjpServiceMapper {
    public static final int DEFAULT_RADIUS_METERS = 1000;
    public static final int DEFAULT_NUM_DEPARTURES = 1;
    private static final Duration DEFAULT_TIME_WINDOW = Duration.ofHours(2L);
    private final OjpService vdvService;
    private final FeedScopedIdMapper idMapper;
    private final ZoneId zoneId;

    public OjpServiceMapper(OjpService vdvService, FeedScopedIdMapper idMapper, ZoneId zoneId) {
        this.vdvService = vdvService;
        this.idMapper = idMapper;
        this.zoneId = zoneId;
    }

    public OJP handleStopEventRequest(OJPStopEventRequestStructure ser) {
        Optional<FeedScopedId> stopId = this.stopPointRef(ser);
        Optional<WgsCoordinate> coordinate = this.coordinate(ser);
        OjpService.StopEventRequestParams params = this.extractStopEventParams(ser);
        List<CallAtStop> callsAtStop = List.of();
        if (stopId.isPresent()) {
            callsAtStop = this.vdvService.findCallsAtStop(stopId.get(), params);
        } else if (coordinate.isPresent()) {
            callsAtStop = this.vdvService.findCallsAtStop(coordinate.get(), params);
        }
        Set<StopEventResponseMapper.OptionalFeature> optional = OjpServiceMapper.mapOptionalFeatures(ser.getParams());
        StopEventResponseMapper mapper = new StopEventResponseMapper(optional, this.zoneId, this.idMapper, this.vdvService::resolveLanguage);
        return mapper.mapCalls(callsAtStop, ZonedDateTime.now());
    }

    protected OjpService.StopEventRequestParams extractStopEventParams(OJPStopEventRequestStructure ser) {
        ZonedDateTime time = Optional.ofNullable(ser.getLocation().getDepArrTime().atZone(this.zoneId)).orElse(ZonedDateTime.now(this.zoneId));
        int numResults = OjpServiceMapper.params(ser).map(s -> s.getNumberOfResults()).map(i -> i.intValue()).orElse(1);
        ArrivalDeparture arrivalDeparture = OjpServiceMapper.arrivalDeparture(ser);
        Duration timeWindow = OjpServiceMapper.timeWindow(ser);
        Set<FeedScopedId> includedAgencies = this.agencyFilter(ser, o -> !OjpServiceMapper.isExclude(o.isExclude()));
        Set<FeedScopedId> includedRoutes = this.lineFilter(ser, o -> !OjpServiceMapper.isExclude(o.isExclude()));
        Set<FeedScopedId> excludedAgencies = this.agencyFilter(ser, f -> OjpServiceMapper.isExclude(f.isExclude()));
        Set<FeedScopedId> excludedRoutes = this.lineFilter(ser, f -> OjpServiceMapper.isExclude(f.isExclude()));
        Set<TransitMode> includedModes = this.modeFilter(ser, m -> !OjpServiceMapper.isExclude(m.isExclude()));
        Set<TransitMode> excludedModes = this.modeFilter(ser, m -> OjpServiceMapper.isExclude(m.isExclude()));
        int maxWalkDistance = Optional.ofNullable(ser.getLocation()).flatMap(l -> l.getIndividualTransportOption().stream().filter(o -> o.getItModeAndModeOfOperation().getPersonalMode() == PersonalModesEnumeration.FOOT).findFirst().flatMap(o -> Optional.ofNullable(o.getMaxDistance()))).map(BigInteger::intValue).orElse(1000);
        return new OjpService.StopEventRequestParams(time.toInstant(), arrivalDeparture, timeWindow, maxWalkDistance, numResults, includedAgencies, includedRoutes, excludedAgencies, excludedRoutes, includedModes, excludedModes);
    }

    private static boolean isExclude(Boolean b) {
        return b == null || Boolean.TRUE.equals(b);
    }

    private Set<TransitMode> modeFilter(OJPStopEventRequestStructure ser, Predicate<ModeFilterStructure> predicate) {
        return OjpServiceMapper.params(ser).map(StopEventParamStructure::getModeFilter).filter(predicate).map(ModeFilterStructure::getPtMode).stream().flatMap(m -> m.stream().map(PtModeMapper::map)).collect(Collectors.toSet());
    }

    private Set<FeedScopedId> agencyFilter(OJPStopEventRequestStructure ser, Predicate<OperatorFilterStructure> predicate) {
        return OjpServiceMapper.params(ser).map(p -> p.getOperatorFilter()).filter(predicate).map(o -> o.getOperatorRef()).stream().flatMap(r -> r.stream().map(ref -> ref.getValue())).map(this.idMapper::parse).collect(Collectors.toSet());
    }

    private Set<FeedScopedId> lineFilter(OJPStopEventRequestStructure ser, Predicate<LineDirectionFilterStructure> predicate) {
        return OjpServiceMapper.params(ser).map(p -> p.getLineFilter()).filter(predicate).map(o -> o.getLine()).stream().flatMap(r -> r.stream().map(l -> l.getLineRef().getValue())).map(this.idMapper::parse).collect(Collectors.toSet());
    }

    private static Optional<StopEventParamStructure> params(OJPStopEventRequestStructure ser) {
        return Optional.ofNullable(ser.getParams());
    }

    private Optional<FeedScopedId> stopPointRef(OJPStopEventRequestStructure ser) {
        return OjpServiceMapper.placeRefStructure(ser).map(PlaceRefStructure::getStopPointRef).map(StopPointRefStructure::getValue).map(this.idMapper::parse);
    }

    private Optional<WgsCoordinate> coordinate(OJPStopEventRequestStructure ser) {
        return OjpServiceMapper.placeRefStructure(ser).map(PlaceRefStructure::getGeoPosition).map(c -> new WgsCoordinate(c.getLatitude().doubleValue(), c.getLongitude().doubleValue()));
    }

    private static Set<StopEventResponseMapper.OptionalFeature> mapOptionalFeatures(StopEventParamStructure params) {
        HashSet<StopEventResponseMapper.OptionalFeature> res = new HashSet<StopEventResponseMapper.OptionalFeature>();
        if (Boolean.TRUE.equals(params.isIncludePreviousCalls())) {
            res.add(StopEventResponseMapper.OptionalFeature.PREVIOUS_CALLS);
        }
        if (Boolean.TRUE.equals(params.isIncludeOnwardCalls())) {
            res.add(StopEventResponseMapper.OptionalFeature.ONWARD_CALLS);
        }
        if (UseRealtimeDataEnumeration.NONE != params.getUseRealtimeData()) {
            res.add(StopEventResponseMapper.OptionalFeature.REALTIME_DATA);
        }
        return res;
    }

    private static Optional<PlaceRefStructure> placeRefStructure(OJPStopEventRequestStructure ser) {
        return Optional.ofNullable(ser.getLocation()).map(PlaceContextStructure::getPlaceRef);
    }

    private static ArrivalDeparture arrivalDeparture(OJPStopEventRequestStructure ser) {
        return OjpServiceMapper.params(ser).map(StopEventParamStructure::getStopEventType).map(OjpServiceMapper::mapType).orElse(ArrivalDeparture.BOTH);
    }

    private static ArrivalDeparture mapType(StopEventTypeEnumeration t) {
        return switch (t) {
            default -> throw new MatchException(null, null);
            case StopEventTypeEnumeration.DEPARTURE -> ArrivalDeparture.DEPARTURES;
            case StopEventTypeEnumeration.ARRIVAL -> ArrivalDeparture.ARRIVALS;
            case StopEventTypeEnumeration.BOTH -> ArrivalDeparture.BOTH;
        };
    }

    private static Duration timeWindow(OJPStopEventRequestStructure ser) {
        return OjpServiceMapper.params(ser).map(StopEventParamStructure::getTimeWindow).orElse(DEFAULT_TIME_WINDOW);
    }
}

