/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.trias.service;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opentripplanner.ext.trias.service.CallAtStop;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.transit.api.request.TripTimeOnDateRequest;
import org.opentripplanner.transit.api.request.TripTimeOnDateRequestBuilder;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.EntityNotFoundException;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.transit.service.TransitService;

public class OjpService {
    private final TransitService transitService;
    private final GraphFinder finder;
    private final int MAX_DEPARTURES = 100;

    public OjpService(TransitService transitService, GraphFinder finder) {
        this.transitService = transitService;
        this.finder = finder;
    }

    public List<CallAtStop> findCallsAtStop(FeedScopedId id, StopEventRequestParams params) throws EntityNotFoundException {
        Collection<StopLocation> stops;
        StopLocation stop = this.transitService.getStopLocation(id);
        if (stop != null) {
            stops = List.of(stop);
        } else {
            StopLocationsGroup station = this.transitService.getStopLocationsGroup(id);
            if (station == null) {
                throw new EntityNotFoundException("StopPointRef", id);
            }
            stops = station.getChildStops();
        }
        List<CallAtStop> calls = this.findCallsAtStop(stops, params);
        return OjpService.sort(params.numDepartures, calls);
    }

    public List<CallAtStop> findCallsAtStop(WgsCoordinate coordinate, StopEventRequestParams params) {
        List<CallAtStop> calls = this.finder.findClosestStops(coordinate.asJtsCoordinate(), params.maximumWalkDistance).stream().flatMap(nearbyStop -> {
            List<StopLocation> stopLocations = List.of(nearbyStop.stop);
            List<CallAtStop> calls1 = this.findCallsAtStop(stopLocations, params);
            return OjpService.sort(params.numDepartures, calls1).stream().map(tt -> tt.withWalkTime(nearbyStop.duration()));
        }).toList();
        return OjpService.sort(params.numDepartures(), calls);
    }

    Optional<String> resolveLanguage(String feedId) {
        return Optional.ofNullable(this.transitService.getFeedInfo(feedId)).map(FeedInfo::getLang);
    }

    private static List<CallAtStop> sort(int numResults, List<CallAtStop> stopTimesInPatterns) {
        return stopTimesInPatterns.stream().sorted(CallAtStop.compareByScheduledDeparture()).limit(numResults).toList();
    }

    private List<CallAtStop> findCallsAtStop(Collection<StopLocation> stopLocations, StopEventRequestParams params) {
        if (params.numDepartures > 100) {
            throw new IllegalArgumentException("Number of departures must be less than 100");
        }
        TripTimeOnDateRequestBuilder builder = TripTimeOnDateRequest.of(stopLocations).withTime(params.time).withArrivalDeparture(params.arrivalDeparture).withTimeWindow(params.timeWindow).withNumberOfDepartures(params.numDepartures).withExcludeAgencies(params.excludedAgencies).withExcludeRoutes(params.excludedRoutes).withExcludeModes(params.excludedModes).withSortOrder(TripTimeOnDate.compareByScheduledDeparture());
        if (params.includesAgencies()) {
            builder.withIncludeAgencies(params.includedAgencies);
        }
        if (params.includesRoutes()) {
            builder.withIncludeRoutes(params.includedRoutes);
        }
        if (params.includesModes()) {
            builder.withIncludeModes(params.includedModes);
        }
        TripTimeOnDateRequest request = builder.build();
        return this.transitService.findTripTimesOnDate(request).stream().map(CallAtStop::noWalking).toList();
    }

    public record StopEventRequestParams(Instant time, ArrivalDeparture arrivalDeparture, Duration timeWindow, int maximumWalkDistance, int numDepartures, Set<FeedScopedId> includedAgencies, Set<FeedScopedId> includedRoutes, Set<FeedScopedId> excludedAgencies, Set<FeedScopedId> excludedRoutes, Set<TransitMode> includedModes, Set<TransitMode> excludedModes) {
        public boolean includesAgencies() {
            return !this.includedAgencies.isEmpty();
        }

        public boolean includesRoutes() {
            return !this.includedRoutes().isEmpty();
        }

        public boolean includesModes() {
            return !this.includedModes.isEmpty();
        }
    }
}

