/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.trias.mapping;

import de.vdv.ojp20.CallAtNearStopStructure;
import de.vdv.ojp20.CallAtStopStructure;
import de.vdv.ojp20.DatedJourneyStructure;
import de.vdv.ojp20.InternationalTextStructure;
import de.vdv.ojp20.JourneyRefStructure;
import de.vdv.ojp20.ModeStructure;
import de.vdv.ojp20.OJP;
import de.vdv.ojp20.OJPResponseStructure;
import de.vdv.ojp20.OJPStopEventDeliveryStructure;
import de.vdv.ojp20.OperatingDayRefStructure;
import de.vdv.ojp20.ServiceArrivalStructure;
import de.vdv.ojp20.ServiceDepartureStructure;
import de.vdv.ojp20.StopEventResultStructure;
import de.vdv.ojp20.StopEventStructure;
import de.vdv.ojp20.siri.DefaultedTextStructure;
import de.vdv.ojp20.siri.DirectionRefStructure;
import de.vdv.ojp20.siri.LineRefStructure;
import de.vdv.ojp20.siri.NaturalLanguageStringStructure;
import de.vdv.ojp20.siri.OperatorRefStructure;
import de.vdv.ojp20.siri.ServiceDelivery;
import de.vdv.ojp20.siri.StopPointRefStructure;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.ext.trias.mapping.PtModeMapper;
import org.opentripplanner.ext.trias.mapping.ServiceDeliveryMapper;
import org.opentripplanner.ext.trias.service.CallAtStop;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.ojp.time.XmlDateTime;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.site.StopLocation;

public class StopEventResponseMapper {
    private final Function<String, Optional<String>> resolveFeedLanguage;
    private final FeedScopedIdMapper idMapper;
    private static final String OJP_NAMESPACE = "http://www.vdv.de/ojp";
    private final Set<OptionalFeature> optionalFeatures;
    private final ZoneId zoneId;

    public StopEventResponseMapper(Set<OptionalFeature> optionalFeatures, ZoneId zoneId, FeedScopedIdMapper idMapper, Function<String, Optional<String>> resolveFeedLanguage) {
        this.optionalFeatures = optionalFeatures;
        this.zoneId = zoneId;
        this.idMapper = idMapper;
        this.resolveFeedLanguage = resolveFeedLanguage;
    }

    public OJP mapCalls(List<CallAtStop> calls, ZonedDateTime timestamp) {
        List<JAXBElement> stopEvents = calls.stream().map(call -> this.stopEventResult((CallAtStop)call)).map(StopEventResponseMapper::jaxbElement).toList();
        OJPStopEventDeliveryStructure sed = new OJPStopEventDeliveryStructure().withStatus(Boolean.valueOf(true));
        stopEvents.forEach(xva$0 -> sed.withRest(new JAXBElement[]{xva$0}));
        ServiceDelivery serviceDelivery = ServiceDeliveryMapper.serviceDelivery(timestamp).withAbstractFunctionalServiceDelivery(new JAXBElement[]{StopEventResponseMapper.jaxbElement(sed)});
        OJPResponseStructure response = new OJPResponseStructure().withServiceDelivery(serviceDelivery);
        return new OJP().withOJPResponse(response);
    }

    private StopEventResultStructure stopEventResult(CallAtStop call) {
        CallAtNearStopStructure callAtNearStop = new CallAtNearStopStructure().withCallAtStop(this.callAtStop(call.tripTimeOnDate())).withWalkDuration(call.walkTime());
        StopEventStructure stopEvent = new StopEventStructure().withThisCall(callAtNearStop).withService(this.datedJourney(call.tripTimeOnDate()));
        if (this.optionalFeatures.contains((Object)OptionalFeature.PREVIOUS_CALLS)) {
            call.tripTimeOnDate().previousTimes().forEach(previous -> stopEvent.withPreviousCall(new CallAtNearStopStructure[]{this.callAtNearStop((TripTimeOnDate)previous)}));
        }
        if (this.optionalFeatures.contains((Object)OptionalFeature.ONWARD_CALLS)) {
            call.tripTimeOnDate().nextTimes().forEach(next -> stopEvent.withOnwardCall(new CallAtNearStopStructure[]{this.callAtNearStop((TripTimeOnDate)next)}));
        }
        return new StopEventResultStructure().withStopEvent(stopEvent).withId(this.eventId(call.tripTimeOnDate()));
    }

    private String eventId(TripTimeOnDate tripTimeOnDate) {
        byte[] bytes = (tripTimeOnDate.getStopTimeKey().toString() + String.valueOf(tripTimeOnDate.getServiceDay())).getBytes(StandardCharsets.UTF_8);
        return UUID.nameUUIDFromBytes(bytes).toString();
    }

    private DatedJourneyStructure datedJourney(TripTimeOnDate tripTimeOnDate) {
        Route route = tripTimeOnDate.getTrip().getRoute();
        StopLocation firstStop = tripTimeOnDate.pattern().getStops().getFirst();
        StopLocation lastStop = tripTimeOnDate.pattern().getStops().getLast();
        return new DatedJourneyStructure().withJourneyRef(new JourneyRefStructure().withValue(this.idMapper.mapToApi(tripTimeOnDate.getTrip().getId()))).withOperatingDayRef(new OperatingDayRefStructure().withValue(tripTimeOnDate.getServiceDay().toString())).withLineRef(new LineRefStructure().withValue(this.idMapper.mapToApi(route.getId()))).withMode(new ModeStructure().withPtMode(PtModeMapper.map(route.getMode()))).withPublishedServiceName(StopEventResponseMapper.internationalText(route.getName(), this.lang(tripTimeOnDate))).withOperatorRef(new OperatorRefStructure().withValue(this.idMapper.mapToApi(route.getAgency().getId()))).withOriginStopPointRef(this.stopPointRef(firstStop)).withOriginText(StopEventResponseMapper.internationalText(firstStop.getName(), this.lang(tripTimeOnDate))).withDestinationStopPointRef(this.stopPointRef(lastStop)).withDestinationText(StopEventResponseMapper.internationalText(tripTimeOnDate.getHeadsign(), this.lang(tripTimeOnDate))).withRouteDescription(StopEventResponseMapper.internationalText(route.getDescription(), this.lang(tripTimeOnDate))).withCancelled(Boolean.valueOf(tripTimeOnDate.getTripTimes().isCanceled())).withDirectionRef(new DirectionRefStructure().withValue(tripTimeOnDate.pattern().getDirection().toString()));
    }

    private CallAtStopStructure callAtStop(TripTimeOnDate tripTimeOnDate) {
        StopLocation stop = tripTimeOnDate.getStop();
        StopPointRefStructure stopPointRef = this.stopPointRef(stop);
        return new CallAtStopStructure().withStopPointRef(stopPointRef).withStopPointName(StopEventResponseMapper.internationalText(stop.getName(), this.lang(tripTimeOnDate))).withServiceArrival(this.serviceArrival(tripTimeOnDate)).withServiceDeparture(this.serviceDeparture(tripTimeOnDate)).withOrder(BigInteger.valueOf(tripTimeOnDate.getGtfsSequence())).withNoBoardingAtStop(Boolean.valueOf(StopEventResponseMapper.isNone(tripTimeOnDate.getPickupType()))).withNoAlightingAtStop(Boolean.valueOf(StopEventResponseMapper.isNone(tripTimeOnDate.getDropoffType()))).withPlannedQuay(StopEventResponseMapper.internationalText(stop.getPlatformCode(), this.lang(tripTimeOnDate))).withNotServicedStop(Boolean.valueOf(tripTimeOnDate.isCancelledStop()));
    }

    private CallAtNearStopStructure callAtNearStop(TripTimeOnDate tripTimeOnDate) {
        return new CallAtNearStopStructure().withCallAtStop(this.callAtStop(tripTimeOnDate));
    }

    @Nullable
    private String lang(TripTimeOnDate tripTimeOnDate) {
        String agencyLang = tripTimeOnDate.getTrip().getRoute().getAgency().getLang();
        if (agencyLang != null) {
            return agencyLang;
        }
        return this.resolveFeedLanguage.apply(tripTimeOnDate.getTrip().getId().getFeedId()).orElse(null);
    }

    private static boolean isNone(PickDrop pickDrop) {
        return pickDrop == PickDrop.NONE;
    }

    private ServiceDepartureStructure serviceDeparture(TripTimeOnDate tripTimeOnDate) {
        ServiceDepartureStructure departure = new ServiceDepartureStructure().withTimetabledTime(new XmlDateTime(tripTimeOnDate.scheduledDeparture().atZone(this.zoneId)));
        tripTimeOnDate.realtimeDeparture().filter(d -> this.optionalFeatures.contains((Object)OptionalFeature.REALTIME_DATA)).ifPresent(time -> departure.withEstimatedTime(new XmlDateTime(time.atZone(this.zoneId))));
        return departure;
    }

    private ServiceArrivalStructure serviceArrival(TripTimeOnDate tripTimeOnDate) {
        ServiceArrivalStructure arrival = new ServiceArrivalStructure().withTimetabledTime(new XmlDateTime(tripTimeOnDate.scheduledArrival().atZone(this.zoneId)));
        tripTimeOnDate.realtimeArrival().filter(d -> this.optionalFeatures.contains((Object)OptionalFeature.REALTIME_DATA)).ifPresent(time -> arrival.withEstimatedTime(new XmlDateTime(time.atZone(this.zoneId))));
        return arrival;
    }

    private StopPointRefStructure stopPointRef(StopLocation stop) {
        return new StopPointRefStructure().withValue(this.idMapper.mapToApi(stop.getId()));
    }

    private static InternationalTextStructure internationalText(I18NString string, String lang) {
        if (string == null) {
            return null;
        }
        return StopEventResponseMapper.internationalText(string.toString(), lang);
    }

    private static InternationalTextStructure internationalText(String string, String lang) {
        if (string == null) {
            return null;
        }
        return new InternationalTextStructure().withText(new NaturalLanguageStringStructure[]{new DefaultedTextStructure().withValue(string).withLang(lang)});
    }

    private static <T> JAXBElement<T> jaxbElement(T value) {
        XmlType xmlType = value.getClass().getAnnotation(XmlType.class);
        return new JAXBElement(new QName(OJP_NAMESPACE, StopEventResponseMapper.getName(xmlType)), value.getClass(), value);
    }

    private static String getName(XmlType xmlType) {
        return xmlType.name().replaceAll("Structure", "");
    }

    public static enum OptionalFeature {
        PREVIOUS_CALLS,
        ONWARD_CALLS,
        REALTIME_DATA;

    }
}

