/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transferanalyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.ext.transferanalyzer.annotations.TransferCouldNotBeRouted;
import org.opentripplanner.ext.transferanalyzer.annotations.TransferRoutingDistanceTooLong;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.DirectGraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.StreetGraphFinder;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.TimetableRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectTransferAnalyzer
implements GraphBuilderModule {
    private static final int RADIUS_MULTIPLIER = 5;
    private static final int MIN_RATIO_TO_LOG = 2;
    private static final int MIN_STREET_DISTANCE_TO_LOG = 100;
    private static final Logger LOG = LoggerFactory.getLogger(DirectTransferAnalyzer.class);
    private final Graph graph;
    private final VertexLinker linker;
    private final TimetableRepository timetableRepository;
    private final DataImportIssueStore issueStore;
    private final double radiusMeters;

    public DirectTransferAnalyzer(Graph graph, VertexLinker linker, TimetableRepository timetableRepository, DataImportIssueStore issueStore, double radiusMeters) {
        this.graph = graph;
        this.linker = linker;
        this.timetableRepository = timetableRepository;
        this.issueStore = issueStore;
        this.radiusMeters = radiusMeters;
    }

    @Override
    public void buildGraph() {
        this.timetableRepository.index();
        LOG.info("Analyzing transfers (this can be time consuming)...");
        ArrayList<TransferInfo> directTransfersTooLong = new ArrayList<TransferInfo>();
        ArrayList<TransferInfo> directTransfersNotFound = new ArrayList<TransferInfo>();
        DirectGraphFinder nearbyStopFinderEuclidian = new DirectGraphFinder(this.timetableRepository.getSiteRepository()::findRegularStops);
        StreetGraphFinder nearbyStopFinderStreets = new StreetGraphFinder(this.graph, this.linker);
        int stopsAnalyzed = 0;
        for (TransitStopVertex originStopVertex : this.graph.getVerticesOfType(TransitStopVertex.class)) {
            NearbyStop euclideanStop;
            if (++stopsAnalyzed % 1000 == 0) {
                LOG.info("{} stops analyzed", (Object)stopsAnalyzed);
            }
            Coordinate c0 = originStopVertex.getCoordinate();
            Map<RegularStop, NearbyStop> stopsEuclidean = nearbyStopFinderEuclidian.findClosestStops(c0, this.radiusMeters).stream().filter(t -> t.stop instanceof RegularStop).collect(Collectors.toMap(t -> (RegularStop)t.stop, t -> t));
            HashMap stopsStreets = new HashMap();
            try {
                nearbyStopFinderStreets.findClosestStops(c0, this.radiusMeters * 5.0).stream().filter(t -> t.stop instanceof RegularStop).forEach(t -> stopsStreets.putIfAbsent((RegularStop)t.stop, t));
            }
            catch (Exception exception) {
                // empty catch block
            }
            RegularStop originStop = originStopVertex.getStop();
            List<RegularStop> stopsConnected = stopsEuclidean.keySet().stream().filter(t -> stopsStreets.containsKey(t) && t != originStop).toList();
            List<RegularStop> stopsUnconnected = stopsEuclidean.keySet().stream().filter(t -> !stopsStreets.containsKey(t) && t != originStop).toList();
            for (RegularStop destStop : stopsConnected) {
                euclideanStop = stopsEuclidean.get(destStop);
                NearbyStop streetStop = (NearbyStop)stopsStreets.get(destStop);
                TransferInfo transferInfo = new TransferInfo(originStop, destStop, euclideanStop.distance, streetStop.distance);
                if (!(transferInfo.ratio > 2.0) || !(transferInfo.streetDistance > 100.0)) continue;
                directTransfersTooLong.add(transferInfo);
            }
            for (RegularStop destStop : stopsUnconnected) {
                euclideanStop = stopsEuclidean.get(destStop);
                directTransfersNotFound.add(new TransferInfo(originStop, destStop, euclideanStop.distance, -1.0));
            }
        }
        directTransfersTooLong.sort(Comparator.comparingDouble(t -> t.ratio));
        Collections.reverse(directTransfersTooLong);
        for (TransferInfo transferInfo : directTransfersTooLong) {
            this.issueStore.add(new TransferRoutingDistanceTooLong(transferInfo.origin, transferInfo.destination, transferInfo.directDistance, transferInfo.streetDistance, transferInfo.ratio));
        }
        directTransfersNotFound.sort(Comparator.comparingDouble(t -> t.directDistance));
        for (TransferInfo transferInfo : directTransfersNotFound) {
            this.issueStore.add(new TransferCouldNotBeRouted(transferInfo.origin, transferInfo.destination, transferInfo.directDistance));
        }
        LOG.info("Done analyzing transfers. {} transfers could not be routed and {} transfers had a too long routing distance.", (Object)directTransfersNotFound.size(), (Object)directTransfersTooLong.size());
    }

    private static class TransferInfo {
        final RegularStop origin;
        final RegularStop destination;
        final double directDistance;
        final double streetDistance;
        final double ratio;

        TransferInfo(RegularStop origin, RegularStop destination, double directDistance, double streetDistance) {
            this.origin = origin;
            this.destination = destination;
            this.directDistance = directDistance;
            this.streetDistance = streetDistance;
            this.ratio = directDistance != 0.0 ? streetDistance / directDistance : 0.0;
        }
    }
}

